package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.RawType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface RemoteUeIpInformation extends TypeLengthInstanceValue<RawType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.REMOTE_UE_IP_INFORMATION;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 193;

    static RemoteUeIpInformation frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static RemoteUeIpInformation frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == RemoteUeIpInformation.TYPE.getType(), "The given raw TLIV is not an REMOTE_UE_IP_INFORMATION");
        final var value = RawType.parse(raw.getValue().getBuffer());
        return new DefaultRemoteUeIpInformation(value, raw);
    }

    static RemoteUeIpInformation ofValue(final Buffer buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static RemoteUeIpInformation ofValue(final Buffer buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static RemoteUeIpInformation ofValue(final String buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static RemoteUeIpInformation ofValue(final String buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static RemoteUeIpInformation ofValue(final RawType value) {
        return ofValue(value, 0);
    }

    static RemoteUeIpInformation ofValue(final RawType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultRemoteUeIpInformation(value, raw);
    }

    @Override
    default RemoteUeIpInformation ensure() {
        return this;
    }

    class DefaultRemoteUeIpInformation extends BaseTliv<RawType> implements RemoteUeIpInformation {
        private DefaultRemoteUeIpInformation(RawType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isRemoteUeIpInformation() {
            return true;
        }

        public RemoteUeIpInformation toRemoteUeIpInformation() {
            return this;
        }
    }
}

