package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.RawType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface ScefPdnConnection extends TypeLengthInstanceValue<RawType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.SCEF_PDN_CONNECTION;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 195;

    static ScefPdnConnection frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static ScefPdnConnection frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == ScefPdnConnection.TYPE.getType(), "The given raw TLIV is not an SCEF_PDN_CONNECTION");
        final var value = RawType.parse(raw.getValue().getBuffer());
        return new DefaultScefPdnConnection(value, raw);
    }

    static ScefPdnConnection ofValue(final Buffer buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static ScefPdnConnection ofValue(final Buffer buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static ScefPdnConnection ofValue(final String buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static ScefPdnConnection ofValue(final String buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static ScefPdnConnection ofValue(final RawType value) {
        return ofValue(value, 0);
    }

    static ScefPdnConnection ofValue(final RawType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultScefPdnConnection(value, raw);
    }

    @Override
    default ScefPdnConnection ensure() {
        return this;
    }

    class DefaultScefPdnConnection extends BaseTliv<RawType> implements ScefPdnConnection {
        private DefaultScefPdnConnection(RawType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isScefPdnConnection() {
            return true;
        }

        public ScefPdnConnection toScefPdnConnection() {
            return this;
        }
    }
}

