package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.RawType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface SecondaryRatUsageDataReport extends TypeLengthInstanceValue<RawType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.SECONDARY_RAT_USAGE_DATA_REPORT;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 201;

    static SecondaryRatUsageDataReport frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static SecondaryRatUsageDataReport frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == SecondaryRatUsageDataReport.TYPE.getType(), "The given raw TLIV is not an SECONDARY_RAT_USAGE_DATA_REPORT");
        final var value = RawType.parse(raw.getValue().getBuffer());
        return new DefaultSecondaryRatUsageDataReport(value, raw);
    }

    static SecondaryRatUsageDataReport ofValue(final Buffer buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static SecondaryRatUsageDataReport ofValue(final Buffer buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static SecondaryRatUsageDataReport ofValue(final String buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static SecondaryRatUsageDataReport ofValue(final String buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static SecondaryRatUsageDataReport ofValue(final RawType value) {
        return ofValue(value, 0);
    }

    static SecondaryRatUsageDataReport ofValue(final RawType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultSecondaryRatUsageDataReport(value, raw);
    }

    @Override
    default SecondaryRatUsageDataReport ensure() {
        return this;
    }

    class DefaultSecondaryRatUsageDataReport extends BaseTliv<RawType> implements SecondaryRatUsageDataReport {
        private DefaultSecondaryRatUsageDataReport(RawType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isSecondaryRatUsageDataReport() {
            return true;
        }

        public SecondaryRatUsageDataReport toSecondaryRatUsageDataReport() {
            return this;
        }
    }
}

