package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.SelectionModeType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface SelectionMode extends TypeLengthInstanceValue<SelectionModeType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.SELECTION_MODE;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 128;

    static SelectionMode frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static SelectionMode frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == SelectionMode.TYPE.getType(), "The given raw TLIV is not an SELECTION_MODE");
        final var value = SelectionModeType.parse(raw.getValue().getBuffer());
        return new DefaultSelectionMode(value, raw);
    }

    static SelectionMode ofValue(final Buffer buffer) {
        final var value = SelectionModeType.ofValue(buffer);
        return ofValue(value);
    }

    static SelectionMode ofValue(final Buffer buffer, final int instance) {
        final var value = SelectionModeType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static SelectionMode ofValue(final String buffer) {
        final var value = SelectionModeType.ofValue(buffer);
        return ofValue(value);
    }

    static SelectionMode ofValue(final String buffer, final int instance) {
        final var value = SelectionModeType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static SelectionMode ofValue(final SelectionModeType value) {
        return ofValue(value, 0);
    }

    static SelectionMode ofValue(final SelectionModeType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultSelectionMode(value, raw);
    }

    @Override
    default SelectionMode ensure() {
        return this;
    }

    class DefaultSelectionMode extends BaseTliv<SelectionModeType> implements SelectionMode {
        private DefaultSelectionMode(SelectionModeType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isSelectionMode() {
            return true;
        }

        public SelectionMode toSelectionMode() {
            return this;
        }
    }
}

