package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.MccMncType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface ServingNetwork extends TypeLengthInstanceValue<MccMncType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.SERVING_NETWORK;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 83;

    static ServingNetwork frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static ServingNetwork frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == ServingNetwork.TYPE.getType(), "The given raw TLIV is not an SERVING_NETWORK");
        final var value = MccMncType.parse(raw.getValue().getBuffer());
        return new DefaultServingNetwork(value, raw);
    }

    static ServingNetwork ofValue(final Buffer buffer) {
        final var value = MccMncType.ofValue(buffer);
        return ofValue(value);
    }

    static ServingNetwork ofValue(final Buffer buffer, final int instance) {
        final var value = MccMncType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static ServingNetwork ofValue(final String buffer) {
        final var value = MccMncType.ofValue(buffer);
        return ofValue(value);
    }

    static ServingNetwork ofValue(final String buffer, final int instance) {
        final var value = MccMncType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static ServingNetwork ofValue(final MccMncType value) {
        return ofValue(value, 0);
    }

    static ServingNetwork ofValue(final MccMncType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultServingNetwork(value, raw);
    }

    @Override
    default ServingNetwork ensure() {
        return this;
    }

    class DefaultServingNetwork extends BaseTliv<MccMncType> implements ServingNetwork {
        private DefaultServingNetwork(MccMncType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isServingNetwork() {
            return true;
        }

        public ServingNetwork toServingNetwork() {
            return this;
        }
    }
}

