package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.RawType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface TwanIdentifierTimestamp extends TypeLengthInstanceValue<RawType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.TWAN_IDENTIFIER_TIMESTAMP;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 179;

    static TwanIdentifierTimestamp frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static TwanIdentifierTimestamp frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == TwanIdentifierTimestamp.TYPE.getType(), "The given raw TLIV is not an TWAN_IDENTIFIER_TIMESTAMP");
        final var value = RawType.parse(raw.getValue().getBuffer());
        return new DefaultTwanIdentifierTimestamp(value, raw);
    }

    static TwanIdentifierTimestamp ofValue(final Buffer buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static TwanIdentifierTimestamp ofValue(final Buffer buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static TwanIdentifierTimestamp ofValue(final String buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static TwanIdentifierTimestamp ofValue(final String buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static TwanIdentifierTimestamp ofValue(final RawType value) {
        return ofValue(value, 0);
    }

    static TwanIdentifierTimestamp ofValue(final RawType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultTwanIdentifierTimestamp(value, raw);
    }

    @Override
    default TwanIdentifierTimestamp ensure() {
        return this;
    }

    class DefaultTwanIdentifierTimestamp extends BaseTliv<RawType> implements TwanIdentifierTimestamp {
        private DefaultTwanIdentifierTimestamp(RawType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isTwanIdentifierTimestamp() {
            return true;
        }

        public TwanIdentifierTimestamp toTwanIdentifierTimestamp() {
            return this;
        }
    }
}

