package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.UliType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface Uli extends TypeLengthInstanceValue<UliType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.ULI;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 86;

    static Uli frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static Uli frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == Uli.TYPE.getType(), "The given raw TLIV is not an ULI");
        final var value = UliType.parse(raw.getValue().getBuffer());
        return new DefaultUli(value, raw);
    }

    static Uli ofValue(final Buffer buffer) {
        final var value = UliType.ofValue(buffer);
        return ofValue(value);
    }

    static Uli ofValue(final Buffer buffer, final int instance) {
        final var value = UliType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Uli ofValue(final String buffer) {
        final var value = UliType.ofValue(buffer);
        return ofValue(value);
    }

    static Uli ofValue(final String buffer, final int instance) {
        final var value = UliType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Uli ofValue(final UliType value) {
        return ofValue(value, 0);
    }

    static Uli ofValue(final UliType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultUli(value, raw);
    }

    @Override
    default Uli ensure() {
        return this;
    }

    class DefaultUli extends BaseTliv<UliType> implements Uli {
        private DefaultUli(UliType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isUli() {
            return true;
        }

        public Uli toUli() {
            return this;
        }
    }
}

