/*
 * Decompiled with CFR 0.152.
 */
package io.soabase.example.hello;

import com.google.common.io.CharStreams;
import io.soabase.core.SoaFeatures;
import io.soabase.core.SoaInfo;
import io.soabase.core.features.client.ClientUtils;
import io.soabase.core.features.client.RequestId;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;

@Path(value="/helloapache")
public class HelloResourceApache {
    private final SoaInfo info;
    private final HttpClient client;

    @Inject
    public HelloResourceApache(SoaFeatures features, @Named(value="apache") HttpClient client) {
        this.info = features.getSoaInfo();
        this.client = client;
    }

    @GET
    public String getHello(@Context HttpHeaders headers) throws Exception {
        String result = "Service Name: " + this.info.getServiceName() + "\nInstance Name: " + this.info.getInstanceName() + "\nRequest Id: " + RequestId.get((HttpHeaders)headers) + "\n";
        URI uri = new URIBuilder().setHost(ClientUtils.serviceNameToHost((String)"goodbye")).setPath("/goodbye").build();
        HttpGet get = new HttpGet(uri);
        ResponseHandler<String> responseHandler = new ResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws IOException {
                return CharStreams.toString((Readable)new InputStreamReader(response.getEntity().getContent()));
            }
        };
        String value = (String)this.client.execute(new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme()), (HttpRequest)get, (ResponseHandler)responseHandler);
        return result + "\nGoodbye app says: \n\t" + value;
    }
}

