/*
 * Decompiled with CFR 0.152.
 */
package io.soabase.example;

import com.google.common.collect.Lists;
import io.dropwizard.Application;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.soabase.core.SoaBundle;
import io.soabase.core.SoaInfo;
import io.soabase.core.features.config.FlexibleConfigurationSourceProvider;
import io.soabase.example.ExampleConfiguration;
import io.soabase.sql.attributes.SqlBundle;
import io.soabase.zookeeper.discovery.CuratorBundle;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Random;
import org.apache.curator.test.InstanceSpec;

public abstract class ExampleAppBase
extends Application<ExampleConfiguration>
implements Managed {
    private final List<Closeable> closeables = Lists.newArrayList();
    private final String configFqpn;

    public static void checkNullConsole() {
        if (!Boolean.getBoolean("debug")) {
            OutputStream nullOut = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            };
            System.setOut(new PrintStream(nullOut));
        }
    }

    public ExampleAppBase(String configFqpn) {
        this.configFqpn = configFqpn;
    }

    public void initialize(Bootstrap<ExampleConfiguration> bootstrap) {
        bootstrap.setConfigurationSourceProvider((ConfigurationSourceProvider)new FlexibleConfigurationSourceProvider());
        bootstrap.addBundle((ConfiguredBundle)new CuratorBundle());
        bootstrap.addBundle((ConfiguredBundle)new SqlBundle());
        bootstrap.addBundle((ConfiguredBundle)new SoaBundle());
    }

    public void run(String ... arguments) throws Exception {
        if (arguments.length == 0) {
            super.run(ExampleAppBase.setSystemAndAdjustArgs(this.configFqpn));
        } else {
            super.run(arguments);
        }
    }

    public static String[] setSystemAndAdjustArgs(String configFqpn) {
        ExampleAppBase.checkNullConsole();
        System.setProperty("dw.curator.connectionString", "localhost:2181");
        System.setProperty("dw.soa.instanceName", "instance-" + new Random().nextInt(10000));
        System.setProperty("dw.soa.discovery.type", "zookeeper");
        System.setProperty("dw.soa.discovery.bindAddress", "localhost");
        System.setProperty("dw.sql.mybatisConfigUrl", "example-mybatis.xml");
        System.setProperty("dw.soa.attributes.type", "sql");
        System.setProperty("dw.server.applicationConnectors[0].port", "" + InstanceSpec.getRandomPort());
        System.setProperty("dw.server.adminConnectors[0].port", "" + InstanceSpec.getRandomPort());
        return new String[]{"server", "|" + configFqpn};
    }

    public void run(ExampleConfiguration configuration, Environment environment) throws Exception {
        environment.lifecycle().manage((Managed)this);
        this.internalRun(configuration, environment);
        SoaInfo info = SoaBundle.getFeatures((Environment)environment).getSoaInfo();
        System.err.println("Main port: " + info.getMainPort());
        System.err.println("Admin port: " + info.getAdminPort());
    }

    protected abstract void internalRun(Configuration var1, Environment var2);

    public void start() throws Exception {
    }

    public void stop() throws Exception {
        for (Closeable closeable : this.closeables) {
            closeable.close();
        }
    }
}

