/*
 * Decompiled with CFR 0.152.
 */
package com.ms.tools.canvas.qr;

import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.HybridBinarizer;
import com.ms.tools.canvas.qr.factory.QrCodeFactory;
import com.ms.tools.core.exception.base.MsToolsException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;

public class QrCodeUtils {
    public static File drawQrCodeLogo(File imgFile, String format, String content, int width, int height) throws MsToolsException {
        return QrCodeFactory.drawImageFile(imgFile, format, content, width, height, null);
    }

    public static ImageOutputStream drawQrCodeLogo(ImageOutputStream imgFile, String format, String content, int width, int height) throws MsToolsException {
        return QrCodeFactory.drawImageStream(imgFile, format, content, width, height, null);
    }

    public static OutputStream drawQrCodeLogo(OutputStream imgFile, String format, String content, int width, int height) throws MsToolsException {
        return QrCodeFactory.drawImageStream(imgFile, format, content, width, height, null);
    }

    public static ImageOutputStream drawQrCodeLogo(ImageOutputStream imgFile, String format, String content, int width, int height, InputStream logo) throws MsToolsException {
        BufferedImage read = null;
        try {
            read = ImageIO.read(logo);
            logo.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return QrCodeFactory.drawImageStream(imgFile, format, content, width, height, read);
    }

    public static OutputStream drawQrCodeLogo(OutputStream imgFile, String format, String content, int width, int height, File logo) throws MsToolsException {
        BufferedImage read = null;
        try {
            read = ImageIO.read(logo);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return QrCodeFactory.drawImageStream(imgFile, format, content, width, height, read);
    }

    public static File drawQrCodeLogo(File imgFile, String format, String content, int width, int height, InputStream logo) throws MsToolsException {
        BufferedImage read = null;
        try {
            read = ImageIO.read(logo);
            logo.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return QrCodeFactory.drawImageFile(imgFile, format, content, width, height, read);
    }

    public static File drawQrCodeLogo(File imgFile, String format, String content, int width, int height, File logo) throws MsToolsException {
        BufferedImage read = null;
        try {
            read = ImageIO.read(logo);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return QrCodeFactory.drawImageFile(imgFile, format, content, width, height, read);
    }

    public static String analysisQrCode(File file) throws MsToolsException {
        if (!file.exists()) {
            return "";
        }
        try {
            BufferedImage imge = ImageIO.read(file);
            MultiFormatReader formatReader = new MultiFormatReader();
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(imge);
            HybridBinarizer binarizer = new HybridBinarizer((LuminanceSource)source);
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)binarizer);
            HashMap<EncodeHintType, String> map = new HashMap<EncodeHintType, String>(1);
            map.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            Result result = formatReader.decode(binaryBitmap, map);
            return result.toString();
        }
        catch (NotFoundException | IOException e) {
            throw new MsToolsException(e);
        }
    }
}

