/*
 * Decompiled with CFR 0.152.
 */
package com.ms.tools.canvas.qr.factory;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.ms.tools.core.exception.base.MsToolsException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;

public class QrCodeFactory {
    private static final Integer DEFAULT_WIDTH = 200;
    private static final Integer DEFAULT_HEIGHT = 200;

    public static File drawImageFile(File imageFile, String format, String content, Integer width, Integer height, BufferedImage logo) throws MsToolsException {
        try {
            BufferedImage bufferedImage = QrCodeFactory.drawQrCode(content, width, height, logo);
            ImageIO.write((RenderedImage)bufferedImage, format, imageFile);
        }
        catch (WriterException | IOException e) {
            throw new MsToolsException(e);
        }
        return imageFile;
    }

    public static ImageOutputStream drawImageStream(ImageOutputStream imageStream, String format, String content, int width, int height, BufferedImage logo) throws MsToolsException {
        try {
            BufferedImage bufferedImage = QrCodeFactory.drawQrCode(content, width, height, logo);
            ImageIO.write((RenderedImage)bufferedImage, format, imageStream);
        }
        catch (WriterException | IOException e) {
            throw new MsToolsException(e);
        }
        return imageStream;
    }

    public static OutputStream drawImageStream(OutputStream imageStream, String format, String content, int width, int height, BufferedImage logo) throws MsToolsException {
        try {
            BufferedImage bufferedImage = QrCodeFactory.drawQrCode(content, width, height, logo);
            ImageIO.write((RenderedImage)bufferedImage, format, imageStream);
        }
        catch (WriterException | IOException e) {
            throw new MsToolsException(e);
        }
        return imageStream;
    }

    private static BufferedImage drawQrCode(String content, int width, int height, BufferedImage logo) throws WriterException, IOException {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hints.put(EncodeHintType.MARGIN, 1);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, width, height, hints);
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, bitMatrix.get(x, y) ? Color.BLACK.getRGB() : Color.WHITE.getRGB());
            }
        }
        if (logo != null) {
            image = QrCodeFactory.logoMatrix(image, logo);
        }
        return image;
    }

    private static BufferedImage logoMatrix(BufferedImage matrixImage, BufferedImage logo) {
        Graphics2D g2 = matrixImage.createGraphics();
        int height = matrixImage.getHeight();
        int width = matrixImage.getWidth();
        g2.drawImage(logo, width * 2 / 5, height * 2 / 5, width * 1 / 5, height * 1 / 5, null);
        BasicStroke stroke = new BasicStroke(5.0f, 1, 1);
        g2.setStroke(stroke);
        RoundRectangle2D.Float round = new RoundRectangle2D.Float(width * 2 / 5, height * 2 / 5, width * 1 / 5, height * 1 / 5, 1.0f, 1.0f);
        g2.setColor(Color.WHITE);
        g2.draw(round);
        BasicStroke stroke2 = new BasicStroke(1.0f, 1, 1);
        g2.setStroke(stroke2);
        RoundRectangle2D.Float round2 = new RoundRectangle2D.Float(width * 2 / 5 + 2, height * 2 / 5 + 2, width * 1 / 5 - 4, height * 1 / 5 - 4, 1.0f, 1.0f);
        g2.setColor(Color.GRAY);
        g2.draw(round2);
        g2.dispose();
        matrixImage.flush();
        return matrixImage;
    }
}

