/*
 * Decompiled with CFR 0.152.
 */
package com.ms.tools.api.aliyun.core;

import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AliyunUrlUtil {
    private static final String CHARSET_UTF8 = "utf8";

    public static String urlEncode(String url) {
        if (!StringUtils.isEmpty((CharSequence)url)) {
            try {
                url = URLEncoder.encode(url, "UTF-8");
            }
            catch (Exception e) {
                System.out.println("Url encode error:" + e.getMessage());
            }
        }
        return url;
    }

    public static String generateQueryString(Map<String, String> params, boolean isEncodeKV) {
        StringBuilder canonicalizedQueryString = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (isEncodeKV) {
                canonicalizedQueryString.append(AliyunUrlUtil.percentEncode(entry.getKey())).append("=").append(AliyunUrlUtil.percentEncode(entry.getValue())).append("&");
                continue;
            }
            canonicalizedQueryString.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        if (canonicalizedQueryString.length() > 1) {
            canonicalizedQueryString.setLength(canonicalizedQueryString.length() - 1);
        }
        return canonicalizedQueryString.toString();
    }

    public static String percentEncode(String value) {
        try {
            return value == null ? null : URLEncoder.encode(value, CHARSET_UTF8).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (Exception exception) {
            return "";
        }
    }
}

