/*
 * Decompiled with CFR 0.152.
 */
package com.ms.tools.api.aliyun.core;

import com.ms.tools.api.aliyun.core.AliyunUrlUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class AliyunSignatureUtils {
    private static final String CHARSET_UTF8 = "utf8";
    private static final String ALGORITHM = "HmacSHA1";
    private static final String SEPARATOR = "&";

    public static Map<String, String> splitQueryString(String url) throws URISyntaxException, UnsupportedEncodingException {
        URI uri = new URI(url);
        String query = uri.getQuery();
        String[] pairs = query.split(SEPARATOR);
        TreeMap<String, String> queryMap = new TreeMap<String, String>();
        for (String pair : pairs) {
            String key;
            int idx = pair.indexOf("=");
            String string = key = idx > 0 ? pair.substring(0, idx) : pair;
            if (queryMap.containsKey(key)) continue;
            queryMap.put(key, URLDecoder.decode(pair.substring(idx + 1), CHARSET_UTF8));
        }
        return queryMap;
    }

    public static String generate(String method, Map<String, String> parameter, String accessKeySecret) throws Exception {
        String signString = AliyunSignatureUtils.generateSignString(method, parameter);
        System.out.println("signString---" + signString);
        byte[] signBytes = AliyunSignatureUtils.hmacSHA1Signature(accessKeySecret + SEPARATOR, signString);
        String signature = AliyunSignatureUtils.newStringByBase64(signBytes);
        System.out.println("signature----" + signature);
        if ("POST".equals(method)) {
            return signature;
        }
        return URLEncoder.encode(signature, "UTF-8");
    }

    public static String generateSignString(String httpMethod, Map<String, String> parameter) throws IOException {
        TreeMap<String, String> sortParameter = new TreeMap<String, String>();
        sortParameter.putAll(parameter);
        String canonicalizedQueryString = AliyunUrlUtil.generateQueryString(sortParameter, true);
        if (null == httpMethod) {
            throw new RuntimeException("httpMethod can not be empty");
        }
        String stringToSign = httpMethod + SEPARATOR + AliyunSignatureUtils.percentEncode("/") + SEPARATOR + AliyunSignatureUtils.percentEncode(canonicalizedQueryString);
        return stringToSign;
    }

    public static String percentEncode(String value) {
        try {
            return value == null ? null : URLEncoder.encode(value, CHARSET_UTF8).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static byte[] hmacSHA1Signature(String secret, String baseString) throws Exception {
        if (StringUtils.isEmpty((CharSequence)secret)) {
            throw new IOException("secret can not be empty");
        }
        if (StringUtils.isEmpty((CharSequence)baseString)) {
            return null;
        }
        Mac mac = Mac.getInstance(ALGORITHM);
        SecretKeySpec keySpec = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), ALGORITHM);
        mac.init(keySpec);
        return mac.doFinal(baseString.getBytes(StandardCharsets.UTF_8));
    }

    public static String newStringByBase64(byte[] bytes) throws UnsupportedEncodingException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return new String(Base64.encodeBase64((byte[])bytes, (boolean)false), StandardCharsets.UTF_8);
    }
}

