/*
 * Decompiled with CFR 0.152.
 */
package com.ms.tools.api.tencent.factory;

import com.ms.tools.api.tencent.factory.ApiSignV3;
import com.ms.tools.api.tencent.factory.TencentCloudApiConfig;
import com.ms.tools.api.tencent.sms.vo.BasicSmsTencentVo;
import com.ms.tools.core.exception.base.MsToolsException;
import com.ms.tools.network.okhttp.OkClient;
import okhttp3.Response;

public class TencentSmsFactory {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String push(String secretId, String secretKey, String bodyJson, BasicSmsTencentVo basic) throws MsToolsException {
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String authorization = ApiSignV3.signV3(secretId, secretKey, timestamp, bodyJson);
        try (Response sync = OkClient.build().addHeader(TencentCloudApiConfig.SmsApi.Authorization, authorization).addHeader(TencentCloudApiConfig.SmsApi.Timestamp, timestamp).addHeader(TencentCloudApiConfig.SmsApi.Action, basic.getAction()).addHeader(TencentCloudApiConfig.SmsApi.Version, basic.getVersion()).addHeader(TencentCloudApiConfig.SmsApi.Region, basic.getRegion()).addHeader(TencentCloudApiConfig.SmsApi.Language, TencentCloudApiConfig.Language.ZH_CH.getLanguage()).uri(TencentCloudApiConfig.Host.MAIN_SMS.getWebsite()).post().body(bodyJson).execute();){
            assert (sync.body() != null);
            String string = sync.body().string();
            return string;
        }
        catch (Exception e) {
            throw new MsToolsException((Throwable)e);
        }
    }
}

