/*
 * Decompiled with CFR 0.152.
 */
package com.ms.tools.api.tencent.sms.response;

import com.alibaba.fastjson2.annotation.JSONField;
import com.ms.tools.api.tencent.sms.response.ErrorRB;
import com.ms.tools.api.tencent.sms.vo.SendSmsTencentVo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SendSmsResponse {
    private Boolean status;
    private Boolean success;
    private Integer successQuantity;
    private Integer failureQuantity;
    @JSONField(name="RequestId")
    private String requestId;
    @JSONField(name="SendStatusSet")
    private List<SendStatusSetRb> sendStatusSet;
    private Map<String, SendStatusSetRb> sendStatus;
    @JSONField(name="Error")
    private ErrorRB error;

    public SendSmsResponse() {
        this.status = true;
        this.success = false;
        this.successQuantity = 0;
        this.failureQuantity = 0;
    }

    public SendSmsResponse(Boolean status, Boolean success, Integer successQuantity, Integer failureQuantity, String requestId, List<SendStatusSetRb> sendStatusSet, Map<String, SendStatusSetRb> sendStatus, ErrorRB error) {
        this.status = status;
        this.success = success;
        this.successQuantity = successQuantity;
        this.failureQuantity = failureQuantity;
        this.requestId = requestId;
        this.sendStatusSet = sendStatusSet;
        this.sendStatus = sendStatus;
        this.error = error;
    }

    public static SendSmsResponse errorResponse() {
        SendSmsResponse response = new SendSmsResponse();
        response.setStatus(false);
        response.setError(ErrorRB.error());
        return response;
    }

    public void finishing(SendSmsTencentVo.Send send) {
        if (this.error != null) {
            this.status = false;
        } else {
            int length = send.getPhoneNumber().length;
            int size = this.getSendStatusSet().size();
            int ok = (int)this.getSendStatusSet().stream().filter(r -> r.getCode().equalsIgnoreCase("ok")).count();
            if (ok == size && size == length) {
                this.setSuccess(true);
            }
            this.setSuccessQuantity(ok);
            this.setFailureQuantity(size - ok);
            this.sendStatus = new HashMap<String, SendStatusSetRb>(this.sendStatusSet.size());
            this.sendStatusSet.forEach(d -> this.sendStatus.put(((SendStatusSetRb)d).phoneNumber, d.finishing()));
        }
    }

    public Boolean getStatus() {
        return this.status;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public Integer getSuccessQuantity() {
        return this.successQuantity;
    }

    public void setSuccessQuantity(Integer successQuantity) {
        this.successQuantity = successQuantity;
    }

    public Integer getFailureQuantity() {
        return this.failureQuantity;
    }

    public void setFailureQuantity(Integer failureQuantity) {
        this.failureQuantity = failureQuantity;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public List<SendStatusSetRb> getSendStatusSet() {
        return this.sendStatusSet;
    }

    public void setSendStatusSet(List<SendStatusSetRb> sendStatusSet) {
        this.sendStatusSet = sendStatusSet;
    }

    public Map<String, SendStatusSetRb> getSendStatus() {
        return this.sendStatus;
    }

    public void setSendStatus(Map<String, SendStatusSetRb> sendStatus) {
        this.sendStatus = sendStatus;
    }

    public ErrorRB getError() {
        return this.error;
    }

    public void setError(ErrorRB error) {
        this.error = error;
    }

    public static class SendStatusSetRb {
        @JSONField(name="SerialNo")
        private String serialNo;
        @JSONField(name="PhoneNumber")
        private String phoneNumber;
        @JSONField(name="Fee")
        private Integer fee;
        @JSONField(name="SessionContext")
        private String sessionContext;
        @JSONField(name="Code")
        private String code;
        @JSONField(name="Message")
        private String message;
        @JSONField(name="IsoCode")
        private String isoCode;
        private Boolean isSuccess;

        public SendStatusSetRb() {
            this.isSuccess = false;
        }

        public SendStatusSetRb(String serialNo, String phoneNumber, Integer fee, String sessionContext, String code, String message, String isoCode, Boolean isSuccess) {
            this.serialNo = serialNo;
            this.phoneNumber = phoneNumber;
            this.fee = fee;
            this.sessionContext = sessionContext;
            this.code = code;
            this.message = message;
            this.isoCode = isoCode;
            this.isSuccess = isSuccess;
        }

        public SendStatusSetRb finishing() {
            if (this.code.equalsIgnoreCase("ok")) {
                this.isSuccess = true;
            }
            return this;
        }

        public String getSerialNo() {
            return this.serialNo;
        }

        public void setSerialNo(String serialNo) {
            this.serialNo = serialNo;
        }

        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        public void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public Integer getFee() {
            return this.fee;
        }

        public void setFee(Integer fee) {
            this.fee = fee;
        }

        public String getSessionContext() {
            return this.sessionContext;
        }

        public void setSessionContext(String sessionContext) {
            this.sessionContext = sessionContext;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getIsoCode() {
            return this.isoCode;
        }

        public void setIsoCode(String isoCode) {
            this.isoCode = isoCode;
        }

        public Boolean getSuccess() {
            return this.isSuccess;
        }

        public void setSuccess(Boolean success) {
            this.isSuccess = success;
        }
    }
}

