/*
 * Decompiled with CFR 0.152.
 */
package spec;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.process.ProcessLogger$;
import scala.sys.process.package$;
import spec.SpecPlay$;

public final class Specgen$ {
    public static Specgen$ MODULE$;

    static {
        new Specgen$();
    }

    public Seq<File> serviceScalaPlay(Logger log, File specPath, File swaggerPath, File generatePath, File servicesPath) {
        log.info((Function0 & Serializable & scala.Serializable)() -> "Running sbt-spec code generation plugin");
        String specToolPath = this.getSpecTool(log);
        Seq specCommand = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{specToolPath, "service-scala-play", "--spec-file", specPath.getPath(), "--swagger-path", swaggerPath.getPath(), "--generate-path", generatePath.getPath(), "--services-path", servicesPath.getPath()}));
        this.runSpecgen(log, (Seq<String>)specCommand);
        File[] generatedFiles = generatePath.listFiles();
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generatedFiles)).toSeq();
    }

    public Seq<File> serviceScalaModels(Logger log, File specPath, File generatePath) {
        log.info((Function0 & Serializable & scala.Serializable)() -> "Running sbt-spec code generation plugin");
        String specToolPath = this.getSpecTool(log);
        Seq specCommand = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{specToolPath, "service-scala-models", "--spec-file", specPath.getPath(), "--generate-path", generatePath.getPath()}));
        this.runSpecgen(log, (Seq<String>)specCommand);
        File[] generatedFiles = generatePath.listFiles();
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generatedFiles)).toSeq();
    }

    public Seq<File> clientSttp(Logger log, File specPath, File generatePath) {
        log.info((Function0 & Serializable & scala.Serializable)() -> "Running sbt-spec code generation plugin");
        String specToolPath = this.getSpecTool(log);
        Seq specCommand = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{specToolPath, "client-scala-sttp", "--spec-file", specPath.getPath(), "--generate-path", generatePath.getPath()}));
        this.runSpecgen(log, (Seq<String>)specCommand);
        File[] generatedFiles = generatePath.listFiles();
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generatedFiles)).toSeq();
    }

    public void runSpecgen(Logger log, Seq<String> specgenCommand) {
        String string;
        int n;
        String stderr;
        block5: {
            Tuple3<Object, String, String> tuple3;
            block4: {
                log.info((Function0 & Serializable & scala.Serializable)() -> "Running specgen tool");
                log.info((Function0 & Serializable & scala.Serializable)() -> specgenCommand.mkString(" "));
                tuple3 = this.runCommand(specgenCommand);
                if (tuple3 == null) break block4;
                int status = BoxesRunTime.unboxToInt((Object)tuple3._1());
                String stdout = (String)tuple3._2();
                stderr = (String)tuple3._3();
                n = status;
                if (stdout == null) break block4;
                string = stdout;
                if (stderr != null) break block5;
            }
            throw new MatchError(tuple3);
        }
        String string2 = stderr;
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)n), (Object)string, (Object)string2);
        Tuple3 tuple32 = tuple3;
        int status = BoxesRunTime.unboxToInt((Object)tuple32._1());
        String stdout = (String)tuple32._2();
        String stderr2 = (String)tuple32._3();
        log.info((Function0 & Serializable & scala.Serializable)() -> stdout);
        log.error((Function0 & Serializable & scala.Serializable)() -> stderr2);
        if (status != 0) {
            throw new Exception(new StringBuilder(39).append("Failed to run specgen tool, exit code: ").append(status).toString());
        }
    }

    public Tuple3<Object, String, String> runCommand(Seq<String> cmd) {
        ByteArrayOutputStream stdoutStream = new ByteArrayOutputStream();
        ByteArrayOutputStream stderrStream = new ByteArrayOutputStream();
        PrintWriter stdoutWriter = new PrintWriter(stdoutStream);
        PrintWriter stderrWriter = new PrintWriter(stderrStream);
        int exitValue = package$.MODULE$.stringSeqToProcess(cmd).$bang(ProcessLogger$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$1 -> {
            stdoutWriter.println(x$1);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$1 -> {
            stderrWriter.println(x$1);
            return BoxedUnit.UNIT;
        }));
        stdoutWriter.close();
        stderrWriter.close();
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)exitValue), (Object)stdoutStream.toString(), (Object)stderrStream.toString());
    }

    public String getSpecTool(Logger log) {
        Object object;
        String osname = this.getOsName();
        String arch = this.getArch();
        String specToolPath = new StringBuilder(8).append("/dist/").append(osname).append("_").append(arch).append("/").append(this.getExeName("specgen")).toString();
        InputStream specToolStream = this.getClass().getResourceAsStream(specToolPath);
        String jarPath = SpecPlay$.MODULE$.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        String specPath = new StringBuilder(0).append(jarPath.substring(0, jarPath.lastIndexOf(46))).append(specToolPath).toString();
        File specPathFile = new File(specPath);
        if (!specPathFile.exists()) {
            log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Unpacking specgen tool into: ").append(specPathFile.getPath()).toString());
            File specPathParent = specPathFile.getParentFile();
            Object object2 = !specPathParent.exists() ? BoxesRunTime.boxToBoolean((boolean)specPathParent.mkdirs()) : BoxedUnit.UNIT;
            Files.copy(specToolStream, Paths.get(specPathFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            object = BoxesRunTime.boxToBoolean((boolean)specPathFile.setExecutable(true));
        } else {
            object = BoxedUnit.UNIT;
        }
        return specPathFile.getPath();
    }

    public String getExeName(String toolName) {
        String string = this.getOsName();
        String string2 = "windows";
        return !(string != null ? !string.equals(string2) : string2 != null) ? new StringBuilder(4).append(toolName).append(".exe").toString() : toolName;
    }

    public String getOsName() {
        String string;
        String osName = System.getProperty("os.name").toLowerCase();
        String string2 = osName;
        if (string2.contains("win")) {
            string = "windows";
        } else if (string2.contains("mac")) {
            string = "darwin";
        } else if (string2.contains("nix") || string2.contains("nux")) {
            string = "linux";
        } else {
            throw new MatchError((Object)string2);
        }
        return string;
    }

    public String getArch() {
        String arch = System.getProperty("os.arch");
        String string = arch;
        String string2 = string.contains("64") ? "amd64" : "x86";
        return string2;
    }

    private Specgen$() {
        MODULE$ = this;
    }
}

