package io.specmatic.test

import io.specmatic.core.ScenarioDetailsForResult
import io.specmatic.core.TestResult

data class TestResultRecord(
    val path: String,
    val method: String,
    val responseStatus: Int,
    val result: TestResult,
    val sourceProvider: String? = null,
    val sourceRepository: String? = null,
    val sourceRepositoryBranch: String? = null,
    val specification: String? = null,
    val serviceType: String? = null,
    val actualResponseStatus: Int = 0,
    val scenario: ScenarioDetailsForResult? = null,
    val isValid: Boolean = true,
) {
    val isExercised = result !in setOf(TestResult.Skipped, TestResult.DidNotRun)
    val isCovered = result in setOf(TestResult.Success, TestResult.Error, TestResult.Failed, TestResult.Covered)
    fun isConnectionRefused() = actualResponseStatus == 0
}