/*
 * Decompiled with CFR 0.152.
 */
package io.specmesh.cli;

import com.google.common.annotations.VisibleForTesting;
import io.specmesh.kafka.provision.Provisioner;
import io.specmesh.kafka.provision.Status;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import picocli.CommandLine;

@CommandLine.Command(name="provision", description={"Apply a specification.yaml to provision kafka resources on a cluster.\nUse 'provision.properties' for common arguments\n Explicit properties file location /app/provision.properties\n\n"})
public final class Provision
implements Callable<Integer> {
    private final Provisioner.ProvisionerBuilder builder = Provisioner.builder();

    @VisibleForTesting
    Provision() {
    }

    public static void main(String[] args) {
        Properties properties = new Properties();
        String propertyFilename = System.getProperty("provision.properties", "provision.properties");
        try (FileInputStream fis = new FileInputStream(propertyFilename);){
            System.out.println("Loading `" + propertyFilename + "` from:" + new File(propertyFilename).getAbsolutePath());
            properties.load(fis);
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> properties.put(key.toString().replace(".", "-"), value)));
            System.out.println("Loaded `properties` from cwd:" + new File(propertyFilename).getAbsolutePath());
        }
        catch (IOException e) {
            System.out.println("Missing `" + propertyFilename + " ` FROM:" + new File(propertyFilename).getAbsolutePath() + "\nERROR:" + e);
            throw new RuntimeException(e);
        }
        CommandLine.PropertiesDefaultProvider provider = new CommandLine.PropertiesDefaultProvider(properties);
        System.exit(new CommandLine((Object)new Provision()).setDefaultValueProvider((CommandLine.IDefaultValueProvider)provider).execute(args));
    }

    @CommandLine.Option(names={"-bs", "--bootstrap-server"}, description={"Kafka bootstrap server url"})
    public void brokerUrl(String brokerUrl) {
        this.builder.brokerUrl(brokerUrl);
    }

    @CommandLine.Option(names={"-srDisabled", "--sr-disabled"}, description={"Ignore schema related operations"})
    public void srDisabled(boolean disable) {
        this.builder.srDisabled(disable);
    }

    @CommandLine.Option(names={"-aclDisabled", "--acl-disabled"}, description={"Ignore ACL related operations"})
    public void aclDisabled(boolean disable) {
        this.builder.aclDisabled(disable);
    }

    @CommandLine.Option(names={"-sr", "--schema-registry"}, description={"schemaRegistryUrl"})
    public void schemaRegistryUrl(String url) {
        this.builder.schemaRegistryUrl(url);
    }

    @CommandLine.Option(names={"-srKey", "--sr-api-key"}, description={"srApiKey for schema registry"})
    public void srApiKey(String key) {
        this.builder.srApiKey(key);
    }

    @CommandLine.Option(names={"-srSecret", "--sr-api-secret"}, description={"srApiSecret for schema secret"})
    public void srApiSecret(String secret) {
        this.builder.srApiSecret(secret);
    }

    @CommandLine.Option(names={"-schemaPath", "--schema-path"}, description={"schemaPath where the set of referenced schemas will be loaded"})
    public void schemaPath(String path) {
        this.builder.schemaPath(path);
    }

    @CommandLine.Option(names={"-spec", "--spec"}, description={"specmesh specification file"})
    public void spec(String path) {
        this.builder.specPath(path);
    }

    @CommandLine.Option(names={"-du", "--domain-user"}, description={"optional custom domain user, to be used when creating ACLs. By default, specmesh expects the principle used to authenticate with Kafka to have the same name as the domain id. For example, given a domain id of 'urn:acme.products', specmesh expects the user to be called 'acme.products', and creates ACLs accordingly. In some situations, e.g. Confluent Cloud Service Accounts, the username is system generated or outside control of administrators.  In these situations, use this option to provide the generated username and specmesh will provision ACLs accordingly."})
    public void domainUserAlias(String alias) {
        this.builder.domainUserAlias(alias);
    }

    @CommandLine.Option(names={"-u", "--username"}, description={"username or api key for the Kafka cluster connection"})
    public void username(String username) {
        this.builder.username(username);
    }

    @CommandLine.Option(names={"-s", "--secret"}, description={"secret credential for the Kafka cluster connection"})
    public void secret(String secret) {
        this.builder.secret(secret);
    }

    @CommandLine.Option(names={"-dry", "--dry-run"}, fallbackValue="false", description={"Compares the cluster resources against the spec, outputting proposed changes if  compatible. If the spec incompatible with the cluster then will fail with a descriptive error message. A return value of '0' = indicates no  changes needed; '1' = changes needed; '-1' not compatible"})
    public void dryRun(boolean enabled) {
        this.builder.dryRun(enabled);
    }

    @CommandLine.Option(names={"-clean", "--clean-unspecified"}, fallbackValue="false", description={"Compares the cluster resources against the spec, outputting proposed set of resources that are unexpected (not specified). Use with '-dry-run' for non-destructive checks. This operation will not create resources, it will only remove unspecified resources"})
    public void cleanUnspecified(boolean enabled) {
        this.builder.cleanUnspecified(enabled);
    }

    @CommandLine.Option(names={"-D", "--property"}, mapFallbackValue="", description={"Specify Java runtime properties for Apache Kafka. "})
    void setProperty(Map<String, String> props) {
        props.forEach(System::setProperty);
    }

    @Override
    public Integer call() {
        Status status = this.builder.build().provision();
        System.out.println(status.toString());
        return status.failed() ? 1 : 0;
    }

    @VisibleForTesting
    Status run() {
        return this.builder.build().provision();
    }
}

