/*
 * Decompiled with CFR 0.152.
 */
package io.specmesh.cli;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.specmesh.apiparser.model.ApiSpec;
import io.specmesh.kafka.Clients;
import io.specmesh.kafka.Exporter;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.kafka.clients.admin.Admin;
import picocli.CommandLine;

@CommandLine.Command(name="export", description={"Build an incomplete spec from a running Cluster"})
@SuppressFBWarnings
public class Export
implements Callable<Integer> {
    private ApiSpec state;
    @CommandLine.Option(names={"-bs", "--bootstrap-server"}, description={"Kafka bootstrap server url"})
    private String brokerUrl;
    @CommandLine.Option(names={"-id", "--domain-id"}, description={"specmesh - domain/prefix - domain identified (app-id) to export against"})
    private String aggid;
    @CommandLine.Option(names={"-u", "--username"}, description={"username or api key for the cluster connection"})
    private String username;
    @CommandLine.Option(names={"-s", "--secret"}, description={"secret credential for the cluster connection"})
    private String secret;

    public static void main(String[] args) {
        System.exit(new CommandLine((Object)Export.builder().build()).execute(args));
    }

    @CommandLine.Option(names={"-D"}, mapFallbackValue="", description={"Specify Java runtime system properties for Apache Kafka. Note: bulk properties can be set via '-Dconfig.properties=somefile.properties "})
    void setProperty(Map<String, String> props) {
        props.forEach((k, v) -> System.setProperty(k, v));
    }

    @Override
    public Integer call() throws Exception {
        try (Admin adminClient = Clients.adminClient((String)this.brokerUrl, (String)this.username, (String)this.secret);){
            ApiSpec apiSpec = Exporter.export((String)this.aggid, (Admin)adminClient);
            ObjectMapper mapper = new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
            System.out.println(mapper.writeValueAsString((Object)apiSpec));
            this.state = apiSpec;
            Integer n = 0;
            return n;
        }
    }

    public ApiSpec state() {
        return this.state;
    }

    private static String $default$brokerUrl() {
        return "";
    }

    Export(ApiSpec state, String brokerUrl, String aggid, String username, String secret) {
        this.state = state;
        this.brokerUrl = brokerUrl;
        this.aggid = aggid;
        this.username = username;
        this.secret = secret;
    }

    public static ExportBuilder builder() {
        return new ExportBuilder();
    }

    public String brokerUrl() {
        return this.brokerUrl;
    }

    public String aggid() {
        return this.aggid;
    }

    public String username() {
        return this.username;
    }

    public String secret() {
        return this.secret;
    }

    public static class ExportBuilder {
        private ApiSpec state;
        private boolean brokerUrl$set;
        private String brokerUrl$value;
        private String aggid;
        private String username;
        private String secret;

        ExportBuilder() {
        }

        public ExportBuilder state(ApiSpec state) {
            this.state = state;
            return this;
        }

        public ExportBuilder brokerUrl(String brokerUrl) {
            this.brokerUrl$value = brokerUrl;
            this.brokerUrl$set = true;
            return this;
        }

        public ExportBuilder aggid(String aggid) {
            this.aggid = aggid;
            return this;
        }

        public ExportBuilder username(String username) {
            this.username = username;
            return this;
        }

        public ExportBuilder secret(String secret) {
            this.secret = secret;
            return this;
        }

        public Export build() {
            String brokerUrl$value = this.brokerUrl$value;
            if (!this.brokerUrl$set) {
                brokerUrl$value = Export.$default$brokerUrl();
            }
            return new Export(this.state, brokerUrl$value, this.aggid, this.username, this.secret);
        }

        public String toString() {
            return "Export.ExportBuilder(state=" + this.state + ", brokerUrl$value=" + this.brokerUrl$value + ", aggid=" + this.aggid + ", username=" + this.username + ", secret=" + this.secret + ")";
        }
    }
}

