/*
 * Decompiled with CFR 0.152.
 */
package io.specmesh.cli;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.specmesh.apiparser.model.ApiSpec;
import io.specmesh.kafka.KafkaApiSpec;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="flatten", description={"Flattens the 'id' into the channel name to support fully qualified channel names"})
@SuppressFBWarnings
public class Flatten
implements Callable<Integer> {
    @CommandLine.Option(names={"-in", "--in-spec"}, description={"Source spec to flatten"})
    private String inSpec;
    @CommandLine.Option(names={"-out", "--out-spec"}, description={"output spec"})
    private String outSpec;

    public static void main(String[] args) {
        System.exit(new CommandLine((Object)Flatten.builder().build()).execute(args));
    }

    @Override
    public Integer call() throws Exception {
        KafkaApiSpec apiSpec1 = KafkaApiSpec.loadFromClassPath((String)this.inSpec, (ClassLoader)Flatten.class.getClassLoader());
        ApiSpec apiSpec = apiSpec1.apiSpec();
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory()).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        Map channels = apiSpec.channels();
        apiSpec.channels(channels);
        System.out.println(mapper.writeValueAsString((Object)apiSpec));
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.outSpec);){
            fileOutputStream.write(mapper.writeValueAsString((Object)apiSpec).getBytes(StandardCharsets.UTF_8));
        }
        return 0;
    }

    private static String $default$inSpec() {
        return "";
    }

    Flatten(String inSpec, String outSpec) {
        this.inSpec = inSpec;
        this.outSpec = outSpec;
    }

    public static FlattenBuilder builder() {
        return new FlattenBuilder();
    }

    public String inSpec() {
        return this.inSpec;
    }

    public String outSpec() {
        return this.outSpec;
    }

    public static class FlattenBuilder {
        private boolean inSpec$set;
        private String inSpec$value;
        private String outSpec;

        FlattenBuilder() {
        }

        public FlattenBuilder inSpec(String inSpec) {
            this.inSpec$value = inSpec;
            this.inSpec$set = true;
            return this;
        }

        public FlattenBuilder outSpec(String outSpec) {
            this.outSpec = outSpec;
            return this;
        }

        public Flatten build() {
            String inSpec$value = this.inSpec$value;
            if (!this.inSpec$set) {
                inSpec$value = Flatten.$default$inSpec();
            }
            return new Flatten(inSpec$value, this.outSpec);
        }

        public String toString() {
            return "Flatten.FlattenBuilder(inSpec$value=" + this.inSpec$value + ", outSpec=" + this.outSpec + ")";
        }
    }
}

