/*
 * Decompiled with CFR 0.152.
 */
package io.specmesh.cli;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.specmesh.kafka.Clients;
import io.specmesh.kafka.KafkaApiSpec;
import io.specmesh.kafka.provision.Provisioner;
import io.specmesh.kafka.provision.Status;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.kafka.clients.admin.Admin;
import picocli.CommandLine;

@CommandLine.Command(name="provision", description={"Apply a specification.yaml to provision kafka resources on a cluster.\nUse 'provision.properties' for common arguments\n Explicit properties file location /app/provision.properties\n\n"})
@SuppressFBWarnings
public class Provision
implements Callable<Integer> {
    private Status state;
    @CommandLine.Option(names={"-bs", "--bootstrap-server"}, description={"Kafka bootstrap server url"})
    private String brokerUrl;
    @CommandLine.Option(names={"-srDisabled", "--sr-disabled"}, description={"Ignore schema related operations"})
    private boolean srDisabled;
    @CommandLine.Option(names={"-aclDisabled", "--acl-disabled"}, description={"Ignore ACL related operations"})
    private boolean aclDisabled;
    @CommandLine.Option(names={"-sr", "--schema-registry"}, description={"schemaRegistryUrl"})
    private String schemaRegistryUrl;
    @CommandLine.Option(names={"-srKey", "--sr-api-key"}, description={"srApiKey for schema registry"})
    private String srApiKey;
    @CommandLine.Option(names={"-srSecret", "--sr-api-secret"}, description={"srApiSecret for schema secret"})
    private String srApiSecret;
    @CommandLine.Option(names={"-schemaPath", "--schema-path"}, description={"schemaPath where the set of referenced schemas will be loaded"})
    private String schemaPath;
    @CommandLine.Option(names={"-spec", "--spec"}, description={"specmesh specification file"})
    private String spec;
    @CommandLine.Option(names={"-u", "--username"}, description={"username or api key for the cluster connection"})
    private String username;
    @CommandLine.Option(names={"-s", "--secret"}, description={"secret credential for the cluster connection"})
    private String secret;
    @CommandLine.Option(names={"-dry", "--dry-run"}, fallbackValue="false", description={"Compares the cluster resources against the spec, outputting proposed changes if  compatible. If the spec incompatible with the cluster then will fail with a descriptive error message. A return value of '0' = indicates no  changes needed; '1' = changes needed; '-1' not compatible"})
    private boolean dryRun;
    @CommandLine.Option(names={"-clean", "--clean-unspecified"}, fallbackValue="false", description={"Compares the cluster resources against the spec, outputting proposed set of resources that are unexpected (not specified). Use with '-dry-run' for non-destructive checks. This operation will not create resources, it will only remove unspecified resources"})
    private boolean cleanUnspecified;

    public static void main(String[] args) {
        Properties properties = new Properties();
        String propertyFilename = System.getProperty("provision.properties", "provision.properties");
        try (FileInputStream fis = new FileInputStream(propertyFilename);){
            System.out.println("Loading `" + propertyFilename + "` from:" + new File(propertyFilename).getAbsolutePath());
            properties.load(fis);
            properties.entrySet().forEach(entry -> properties.put(entry.getKey().toString().replace(".", "-"), entry.getValue()));
            System.out.println("Loaded `properties` from cwd:" + new File(propertyFilename).getAbsolutePath());
        }
        catch (IOException e) {
            System.out.println("Missing `" + propertyFilename + " ` FROM:" + new File(propertyFilename).getAbsolutePath() + "\nERROR:" + e);
            e.printStackTrace();
        }
        CommandLine.PropertiesDefaultProvider provider = new CommandLine.PropertiesDefaultProvider(properties);
        System.exit(new CommandLine((Object)Provision.builder().build()).setDefaultValueProvider((CommandLine.IDefaultValueProvider)provider).execute(args));
    }

    @CommandLine.Option(names={"-D", "--property"}, mapFallbackValue="", description={"Specify Java runtime properties for Apache Kafka. "})
    void setProperty(Map<String, String> props) {
        props.forEach(System::setProperty);
    }

    @Override
    public Integer call() throws Exception {
        Status status = Provisioner.provision((!this.aclDisabled ? 1 : 0) != 0, (boolean)this.dryRun, (boolean)this.cleanUnspecified, (KafkaApiSpec)this.specMeshSpec(), (String)this.schemaPath, (Admin)Clients.adminClient((String)this.brokerUrl, (String)this.username, (String)this.secret), (Optional)Clients.schemaRegistryClient((!this.srDisabled ? 1 : 0) != 0, (String)this.schemaRegistryUrl, (String)this.srApiKey, (String)this.srApiSecret));
        System.out.println(status.toString());
        this.state = status;
        return 0;
    }

    private KafkaApiSpec specMeshSpec() {
        return KafkaApiSpec.loadFromClassPath((String)this.spec, (ClassLoader)Provision.class.getClassLoader());
    }

    private static String $default$brokerUrl() {
        return "";
    }

    Provision(Status state, String brokerUrl, boolean srDisabled, boolean aclDisabled, String schemaRegistryUrl, String srApiKey, String srApiSecret, String schemaPath, String spec, String username, String secret, boolean dryRun, boolean cleanUnspecified) {
        this.state = state;
        this.brokerUrl = brokerUrl;
        this.srDisabled = srDisabled;
        this.aclDisabled = aclDisabled;
        this.schemaRegistryUrl = schemaRegistryUrl;
        this.srApiKey = srApiKey;
        this.srApiSecret = srApiSecret;
        this.schemaPath = schemaPath;
        this.spec = spec;
        this.username = username;
        this.secret = secret;
        this.dryRun = dryRun;
        this.cleanUnspecified = cleanUnspecified;
    }

    public static ProvisionBuilder builder() {
        return new ProvisionBuilder();
    }

    public Status state() {
        return this.state;
    }

    public String brokerUrl() {
        return this.brokerUrl;
    }

    public boolean srDisabled() {
        return this.srDisabled;
    }

    public boolean aclDisabled() {
        return this.aclDisabled;
    }

    public String schemaRegistryUrl() {
        return this.schemaRegistryUrl;
    }

    public String srApiKey() {
        return this.srApiKey;
    }

    public String srApiSecret() {
        return this.srApiSecret;
    }

    public String schemaPath() {
        return this.schemaPath;
    }

    public String spec() {
        return this.spec;
    }

    public String username() {
        return this.username;
    }

    public String secret() {
        return this.secret;
    }

    public boolean dryRun() {
        return this.dryRun;
    }

    public boolean cleanUnspecified() {
        return this.cleanUnspecified;
    }

    public static class ProvisionBuilder {
        private Status state;
        private boolean brokerUrl$set;
        private String brokerUrl$value;
        private boolean srDisabled;
        private boolean aclDisabled;
        private String schemaRegistryUrl;
        private String srApiKey;
        private String srApiSecret;
        private String schemaPath;
        private String spec;
        private String username;
        private String secret;
        private boolean dryRun;
        private boolean cleanUnspecified;

        ProvisionBuilder() {
        }

        public ProvisionBuilder state(Status state) {
            this.state = state;
            return this;
        }

        public ProvisionBuilder brokerUrl(String brokerUrl) {
            this.brokerUrl$value = brokerUrl;
            this.brokerUrl$set = true;
            return this;
        }

        public ProvisionBuilder srDisabled(boolean srDisabled) {
            this.srDisabled = srDisabled;
            return this;
        }

        public ProvisionBuilder aclDisabled(boolean aclDisabled) {
            this.aclDisabled = aclDisabled;
            return this;
        }

        public ProvisionBuilder schemaRegistryUrl(String schemaRegistryUrl) {
            this.schemaRegistryUrl = schemaRegistryUrl;
            return this;
        }

        public ProvisionBuilder srApiKey(String srApiKey) {
            this.srApiKey = srApiKey;
            return this;
        }

        public ProvisionBuilder srApiSecret(String srApiSecret) {
            this.srApiSecret = srApiSecret;
            return this;
        }

        public ProvisionBuilder schemaPath(String schemaPath) {
            this.schemaPath = schemaPath;
            return this;
        }

        public ProvisionBuilder spec(String spec) {
            this.spec = spec;
            return this;
        }

        public ProvisionBuilder username(String username) {
            this.username = username;
            return this;
        }

        public ProvisionBuilder secret(String secret) {
            this.secret = secret;
            return this;
        }

        public ProvisionBuilder dryRun(boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public ProvisionBuilder cleanUnspecified(boolean cleanUnspecified) {
            this.cleanUnspecified = cleanUnspecified;
            return this;
        }

        public Provision build() {
            String brokerUrl$value = this.brokerUrl$value;
            if (!this.brokerUrl$set) {
                brokerUrl$value = Provision.$default$brokerUrl();
            }
            return new Provision(this.state, brokerUrl$value, this.srDisabled, this.aclDisabled, this.schemaRegistryUrl, this.srApiKey, this.srApiSecret, this.schemaPath, this.spec, this.username, this.secret, this.dryRun, this.cleanUnspecified);
        }

        public String toString() {
            return "Provision.ProvisionBuilder(state=" + this.state + ", brokerUrl$value=" + this.brokerUrl$value + ", srDisabled=" + this.srDisabled + ", aclDisabled=" + this.aclDisabled + ", schemaRegistryUrl=" + this.schemaRegistryUrl + ", srApiKey=" + this.srApiKey + ", srApiSecret=" + this.srApiSecret + ", schemaPath=" + this.schemaPath + ", spec=" + this.spec + ", username=" + this.username + ", secret=" + this.secret + ", dryRun=" + this.dryRun + ", cleanUnspecified=" + this.cleanUnspecified + ")";
        }
    }
}

