/*
 * Decompiled with CFR 0.152.
 */
package sphere;

import akka.actor.Cancellable;
import play.Application;
import play.Configuration;
import play.Logger;
import play.Plugin;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.Akka;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import sphere.Sphere;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class CategoryTreeRefreshPlayPlugin
extends Plugin {
    private final Application app;
    private final Configuration config;
    private Cancellable task;
    private final Logger.ALogger logger = Logger.of(CategoryTreeRefreshPlayPlugin.class);

    public CategoryTreeRefreshPlayPlugin(Application app) {
        this.app = app;
        this.config = app.configuration().getConfig("sphere.categories.refresh");
    }

    public void onStart() {
        this.logger.info("Starting category refresh plugin.");
        FiniteDuration initialDelay = CategoryTreeRefreshPlayPlugin.convert(Duration.create((String)this.config.getString("initialDelay")));
        FiniteDuration delay = CategoryTreeRefreshPlayPlugin.convert(Duration.create((String)this.config.getString("delay")));
        this.task = Akka.system().scheduler().schedule(initialDelay, delay, (Runnable)new UnitOfWork(), Akka.system().dispatcher());
    }

    public void onStop() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    public boolean enabled() {
        return this.config.getBoolean("enabled");
    }

    private static FiniteDuration convert(Duration duration) {
        return new FiniteDuration(duration.length(), duration.unit());
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private class UnitOfWork
    implements Runnable {
        private UnitOfWork() {
        }

        @Override
        public void run() {
            CategoryTreeRefreshPlayPlugin.this.logger.debug("Refreshing the category tree.");
            Sphere.getInstance().categories().rebuildAsync();
        }
    }
}

