/*
 * Decompiled with CFR 0.152.
 */
package sphere;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.neovisionaries.i18n.CountryCode;
import io.sphere.client.CommandRequest;
import io.sphere.client.SphereClientException;
import io.sphere.client.SphereResult;
import io.sphere.client.exceptions.SphereBackendException;
import io.sphere.client.model.LocalizedString;
import io.sphere.client.model.Money;
import io.sphere.client.model.ReferenceId;
import io.sphere.client.model.VersionedId;
import io.sphere.client.shop.CartService;
import io.sphere.client.shop.CreateOrderBuilder;
import io.sphere.client.shop.OrderService;
import io.sphere.client.shop.model.Address;
import io.sphere.client.shop.model.Cart;
import io.sphere.client.shop.model.CartUpdate;
import io.sphere.client.shop.model.Order;
import io.sphere.client.shop.model.PaymentState;
import io.sphere.client.shop.model.ShippingMethod;
import io.sphere.client.shop.model.ShippingRate;
import io.sphere.client.shop.model.TaxCategory;
import io.sphere.internal.util.Log;
import io.sphere.internal.util.Util;
import java.util.Currency;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jcip.annotations.ThreadSafe;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import sphere.CartModifiedException;
import sphere.Session;
import sphere.util.Async;

@ThreadSafe
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class CurrentCart {
    private final Session session = Session.current();
    private final CartService cartService;
    private final OrderService orderService;
    private Currency cartCurrency;
    private Cart.InventoryMode inventoryMode;
    private static String thisAppServerId = UUID.randomUUID().toString().substring(0, 13);

    public CurrentCart(CartService cartService, OrderService orderService, Currency cartCurrency, Cart.InventoryMode inventoryMode) {
        this.cartService = cartService;
        this.orderService = orderService;
        this.cartCurrency = cartCurrency;
        this.inventoryMode = inventoryMode;
    }

    private Cart emptyCart() {
        return Cart.createEmpty((Currency)this.cartCurrency, (Cart.InventoryMode)this.inventoryMode);
    }

    public Cart fetch() {
        return Async.await(this.fetchAsync());
    }

    public F.Promise<Cart> fetchAsync() {
        final VersionedId cartId = this.session.getCartId();
        if (cartId != null) {
            Log.trace((String)("[cart] Fetch: found cart id in session, fetching cart from the backend: " + cartId));
            return Async.asPlayPromise(Futures.transform((ListenableFuture)this.cartService.byId(cartId.getId()).fetchAsync(), (Function)new Function<Optional<Cart>, Cart>(){

                @Nullable
                public Cart apply(@Nullable Optional<Cart> cart) {
                    if (cart.isPresent()) {
                        return (Cart)cart.get();
                    }
                    Log.warn((String)("[cart] Cart stored in session not found in the backend: " + cartId + ". " + "Returning an empty dummy cart and clearing cart in session."));
                    CurrentCart.this.session.clearCart();
                    return CurrentCart.this.emptyCart();
                }
            }));
        }
        Log.trace((String)"[cart] No cartId in session, returning an empty dummy cart.");
        return F.Promise.pure((Object)this.emptyCart());
    }

    public int getQuantity() {
        Integer cachedInSession = this.session.getCartTotalQuantity();
        int quantity = cachedInSession == null ? 0 : cachedInSession;
        Log.trace((String)("[cart] CurrentCart.getTotalQuantity() = " + quantity + " (from session)."));
        return quantity;
    }

    public Cart addLineItem(String productId, int variantId, int quantity) {
        return Async.awaitResult(this.addLineItemAsync(productId, variantId, quantity));
    }

    public F.Promise<SphereResult<Cart>> addLineItemAsync(String productId, int variantId, int quantity) {
        return this.updateAsync(new CartUpdate().addLineItem(quantity, productId, variantId));
    }

    public Cart addLineItem(String productId, int quantity) {
        return Async.awaitResult(this.addLineItemAsync(productId, quantity));
    }

    public F.Promise<SphereResult<Cart>> addLineItemAsync(String productId, int quantity) {
        return this.updateAsync(new CartUpdate().addLineItem(quantity, productId));
    }

    public Cart addCustomLineItem(LocalizedString name, Money money, String slug, ReferenceId<TaxCategory> taxCategory) {
        return Async.awaitResult(this.addCustomLineItemAsync(name, money, slug, taxCategory, 1));
    }

    public Cart addCustomLineItem(LocalizedString name, Money money, String slug, ReferenceId<TaxCategory> taxCategory, int quantity) {
        return Async.awaitResult(this.addCustomLineItemAsync(name, money, slug, taxCategory, quantity));
    }

    public F.Promise<SphereResult<Cart>> addCustomLineItemAsync(LocalizedString name, Money money, String slug, ReferenceId<TaxCategory> taxCategory) {
        return this.updateAsync(new CartUpdate().addCustomLineItem(name, money, slug, taxCategory, 1));
    }

    public F.Promise<SphereResult<Cart>> addCustomLineItemAsync(LocalizedString name, Money money, String slug, ReferenceId<TaxCategory> taxCategory, int quantity) {
        return this.updateAsync(new CartUpdate().addCustomLineItem(name, money, slug, taxCategory, quantity));
    }

    public Cart removeLineItem(String lineItemId) {
        return Async.awaitResult(this.removeLineItemAsync(lineItemId));
    }

    public F.Promise<SphereResult<Cart>> removeLineItemAsync(String lineItemId) {
        return this.updateAsync(new CartUpdate().removeLineItem(lineItemId));
    }

    public Cart decreaseLineItemQuantity(String lineItemId, int quantity) {
        return Async.awaitResult(this.decreaseLineItemQuantityAsync(lineItemId, quantity));
    }

    public F.Promise<SphereResult<Cart>> decreaseLineItemQuantityAsync(String lineItemId, int quantity) {
        return this.updateAsync(new CartUpdate().decreaseLineItemQuantity(lineItemId, quantity));
    }

    public Cart setLineItemQuantity(String lineItemId, int quantity) {
        return Async.awaitResult(this.setLineItemQuantityAsync(lineItemId, quantity));
    }

    public F.Promise<SphereResult<Cart>> setLineItemQuantityAsync(String lineItemId, int quantity) {
        return this.updateAsync(new CartUpdate().setLineItemQuantity(lineItemId, quantity));
    }

    public Cart setCustomerEmail(String email) {
        return Async.awaitResult(this.setCustomerEmailAsync(email));
    }

    public F.Promise<SphereResult<Cart>> setCustomerEmailAsync(String email) {
        return this.updateAsync(new CartUpdate().setCustomerEmail(email));
    }

    public Cart setShippingAddress(Address address) {
        return Async.awaitResult(this.setShippingAddressAsync(address));
    }

    public F.Promise<SphereResult<Cart>> setShippingAddressAsync(Address address) {
        return this.updateAsync(new CartUpdate().setShippingAddress(address));
    }

    public Cart clearShippingAddress() {
        return Async.awaitResult(this.setShippingAddressAsync(null));
    }

    public F.Promise<SphereResult<Cart>> clearShippingAddressAsync() {
        return this.setShippingAddressAsync(null);
    }

    public Cart setBillingAddress(Address address) {
        return Async.awaitResult(this.setBillingAddressAsync(address));
    }

    public F.Promise<SphereResult<Cart>> setBillingAddressAsync(Address address) {
        return this.updateAsync(new CartUpdate().setBillingAddress(address));
    }

    public Cart setCountry(CountryCode country) {
        return Async.awaitResult(this.setCountryAsync(country));
    }

    public F.Promise<SphereResult<Cart>> setCountryAsync(CountryCode country) {
        return this.updateAsync(new CartUpdate().setCountry(country));
    }

    public Cart setShippingMethod(ReferenceId<ShippingMethod> shippingMethod) {
        return Async.awaitResult(this.setShippingMethodAsync(shippingMethod));
    }

    public F.Promise<SphereResult<Cart>> setShippingMethodAsync(ReferenceId<ShippingMethod> shippingMethod) {
        return this.updateAsync(new CartUpdate().setShippingMethod(shippingMethod));
    }

    public Cart setCustomShippingMethod(String shippingMethodName, ShippingRate shippingRate, ReferenceId<TaxCategory> taxCategory) {
        return Async.awaitResult(this.setCustomShippingMethodAsync(shippingMethodName, shippingRate, taxCategory));
    }

    public F.Promise<SphereResult<Cart>> setCustomShippingMethodAsync(String shippingMethodName, ShippingRate shippingRate, ReferenceId<TaxCategory> taxCategory) {
        return this.updateAsync(new CartUpdate().setCustomShippingMethod(shippingMethodName, shippingRate, taxCategory));
    }

    public Cart recalculate() {
        return Async.awaitResult(this.recalculateAsync());
    }

    public F.Promise<SphereResult<Cart>> recalculateAsync() {
        return this.updateAsync(new CartUpdate().recalculate());
    }

    public String createCartSnapshotId() {
        VersionedId cartId = (VersionedId)Util.syncResult(this.ensureCart());
        return new CartSnapshotId(cartId, System.currentTimeMillis(), thisAppServerId).toString();
    }

    public boolean isSafeToCreateOrder(String cartSnapshotId) {
        CartSnapshotId checkoutId = CartSnapshotId.parse(cartSnapshotId);
        if (checkoutId.appServerId.equals(thisAppServerId) && System.currentTimeMillis() - checkoutId.timeStamp < 500L) {
            throw new SphereClientException("The checkoutId must be a valid string, generated when starting the checkout process. See the documentation of CurrentCart.orderCart().");
        }
        VersionedId currentCartId = this.session.getCartId();
        boolean isSafeToCreateOrder = checkoutId.cartId.equals((Object)currentCartId);
        if (!isSafeToCreateOrder) {
            Log.warn((String)("[cart] It's not safe to order - cart was probably modified in a different browser tab.\ncheckoutId: " + checkoutId.cartId + ", current cart: " + currentCartId));
        }
        return isSafeToCreateOrder;
    }

    public Order createOrder(String cartSnapshotId, PaymentState paymentState) {
        return Async.awaitResult(this.createOrderAsync(cartSnapshotId, paymentState));
    }

    public F.Promise<SphereResult<Order>> createOrderAsync(String cartSnapshotId, PaymentState paymentState) {
        return this.createOrderAsync(new CreateOrderBuilder(this.session.getCartId(), paymentState).setCartSnapshotId(cartSnapshotId));
    }

    public Order createOrder(PaymentState paymentState) {
        return Async.awaitResult(this.createOrderAsync(paymentState));
    }

    public Order createOrder(CreateOrderBuilder createOrderBuilder) {
        return Async.awaitResult(this.createOrderAsync(createOrderBuilder));
    }

    public F.Promise<SphereResult<Order>> createOrderAsync(PaymentState paymentState) {
        VersionedId cartId = this.session.getCartId();
        if (cartId != null) {
            return this.createOrderAsync(new CreateOrderBuilder(cartId, paymentState));
        }
        throw new SphereClientException("A cart can not be ordered because this CurrentCart instance is not valid (the cart session is empty.");
    }

    public F.Promise<SphereResult<Order>> createOrderAsync(CreateOrderBuilder createOrderBuilder) {
        Optional cartSnapshotId = createOrderBuilder.getCartSnapshotId();
        if (cartSnapshotId.isPresent() && this.session.getCartId() != null && !this.isSafeToCreateOrder((String)cartSnapshotId.get())) {
            throw new CartModifiedException("The cart was likely modified in a different browser tab. Please call CurrentCart.isSafeToCreateOrder() before creating the order.");
        }
        VersionedId cartId = createOrderBuilder.getCartId();
        PaymentState paymentState = createOrderBuilder.getPaymentState();
        Log.debug((String)String.format("Ordering cart %s using payment state %s.", cartId, paymentState));
        return Async.asPlayPromise(Futures.transform((ListenableFuture)this.orderService.createOrder(createOrderBuilder).executeAsync(), (Function)new Function<SphereResult<Order>, SphereResult<Order>>(){

            public SphereResult<Order> apply(@Nullable SphereResult<Order> order) {
                CurrentCart.this.session.clearCart();
                return order;
            }
        }));
    }

    public Cart update(CartUpdate update) {
        return Async.awaitResult(this.updateAsync(update));
    }

    public F.Promise<SphereResult<Cart>> updateAsync(final CartUpdate update) {
        return Async.asPlayPromise(Futures.transform(this.ensureCart(), (AsyncFunction)new AsyncFunction<SphereResult<VersionedId>, SphereResult<Cart>>(){

            public ListenableFuture<SphereResult<Cart>> apply(SphereResult<VersionedId> cartIdResult) {
                if (cartIdResult.isError()) {
                    Futures.immediateFuture((Object)cartIdResult.castErrorInternal());
                }
                return CurrentCart.this.executeAsync((VersionedId)cartIdResult.getValue(), update);
            }
        }));
    }

    private ListenableFuture<SphereResult<Cart>> executeAsync(@Nonnull VersionedId currentCartId, @Nonnull CartUpdate update) {
        Log.trace((String)("[cart] Updating cart " + currentCartId));
        CommandRequest commandRequest = this.cartService.updateCart(currentCartId, update);
        return Futures.transform((ListenableFuture)commandRequest.executeAsync(), (AsyncFunction)new AsyncFunction<SphereResult<Cart>, SphereResult<Cart>>(){

            @Nullable
            public ListenableFuture<SphereResult<Cart>> apply(@Nullable SphereResult<Cart> cartResult) {
                if (cartResult.isSuccess()) {
                    CurrentCart.this.session.putCart((Cart)cartResult.getValue());
                    return Futures.immediateFuture(cartResult);
                }
                SphereResult<Cart> failedCartResult = cartResult;
                SphereBackendException e = failedCartResult.getGenericError();
                switch (e.getStatusCode()) {
                    case 404: {
                        return Futures.immediateFuture((Object)CurrentCart.this.clearCartOnNotFound(e.getMessage()));
                    }
                    case 409: {
                        final VersionedId cartId = CurrentCart.this.session.getCartId();
                        if (cartId == null) {
                            Log.error((String)"[cart] Cart modification failed with concurrent modification, yet there is no cart in the session. This is most likely a bug you should report. Clearing the cart from session as a last resort.");
                            CurrentCart.this.session.clearCart();
                            return Futures.immediateFuture(failedCartResult);
                        }
                        Log.warn((String)("[cart] ConcurrentModification error when modifying the cart " + cartId + ". " + "Ignoring the modification and repairing session state. " + e.getMessage()));
                        return Futures.transform((ListenableFuture)CurrentCart.this.cartService.byId(cartId.getId()).fetchAsync(), (Function)new Function<Optional<Cart>, SphereResult<Cart>>(){

                            @Nullable
                            public SphereResult<Cart> apply(Optional<Cart> existingCart) {
                                if (!existingCart.isPresent()) {
                                    return CurrentCart.this.clearCartOnNotFound(cartId.toString());
                                }
                                return SphereResult.success((Object)CurrentCart.this.session.putCart((Cart)existingCart.get()));
                            }
                        });
                    }
                }
                Futures.immediateFuture(failedCartResult);
                return Futures.immediateFuture(failedCartResult);
            }
        });
    }

    private SphereResult<Cart> clearCartOnNotFound(String msg) {
        Log.warn((String)("[cart] Cart not found (probably old cart that was deleted?).Clearing the cart from session. " + msg));
        this.session.clearCart();
        return SphereResult.success((Object)this.emptyCart());
    }

    private ListenableFuture<SphereResult<VersionedId>> ensureCart() {
        VersionedId cartId = this.session.getCartId();
        if (cartId != null) {
            return Futures.immediateFuture((Object)SphereResult.success((Object)cartId));
        }
        VersionedId customerId = this.session.getCustomerId();
        return Futures.transform(this.getExistingCartOrCreateNew(customerId), (Function)new Function<SphereResult<Cart>, SphereResult<VersionedId>>(){

            @Nullable
            public SphereResult<VersionedId> apply(@Nullable SphereResult<Cart> existingOrNewCart) {
                if (existingOrNewCart.isSuccess()) {
                    CurrentCart.this.session.putCart((Cart)existingOrNewCart.getValue());
                }
                return existingOrNewCart.transform((Function)new Function<Cart, VersionedId>(){

                    public VersionedId apply(@Nullable Cart cart) {
                        return cart.getIdAndVersion();
                    }
                });
            }
        });
    }

    private ListenableFuture<SphereResult<Cart>> getExistingCartOrCreateNew(final VersionedId customerId) {
        ListenableFuture getFuture = customerId == null ? Futures.immediateFuture((Object)Optional.absent()) : this.cartService.forCustomer(customerId.getId()).fetchAsync();
        return Futures.transform((ListenableFuture)getFuture, (AsyncFunction)new AsyncFunction<Optional<Cart>, SphereResult<Cart>>(){

            public ListenableFuture<SphereResult<Cart>> apply(Optional<Cart> existingCart) throws Exception {
                if (existingCart.isPresent()) {
                    return Futures.immediateFuture((Object)SphereResult.success((Object)existingCart.get()));
                }
                return customerId != null ? CurrentCart.this.cartService.createCart(CurrentCart.this.cartCurrency, customerId.getId(), CurrentCart.this.inventoryMode).executeAsync() : CurrentCart.this.cartService.createCart(CurrentCart.this.cartCurrency, CurrentCart.this.inventoryMode).executeAsync();
            }
        });
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private static class CartSnapshotId {
        final VersionedId cartId;
        final long timeStamp;
        final String appServerId;
        static final String separator = "_";

        CartSnapshotId(VersionedId cartId, long timeStamp, String appServerId) {
            this.cartId = cartId;
            this.timeStamp = timeStamp;
            this.appServerId = appServerId;
        }

        public String toString() {
            return this.cartId.getVersion() + separator + this.cartId.getId() + separator + this.timeStamp + separator + this.appServerId;
        }

        static CartSnapshotId parse(String checkoutSummaryId) {
            int cartVersion;
            long timeStamp;
            String[] parts = checkoutSummaryId.split(separator);
            if (parts.length != 4) {
                throw new SphereClientException("Malformed checkoutId (length): " + checkoutSummaryId);
            }
            try {
                timeStamp = Long.parseLong(parts[2]);
            }
            catch (NumberFormatException ignored) {
                throw new SphereClientException("Malformed checkoutId (timestamp): " + checkoutSummaryId);
            }
            String appServerId = parts[3];
            try {
                cartVersion = Integer.parseInt(parts[0]);
            }
            catch (NumberFormatException ignored) {
                throw new SphereClientException("Malformed checkoutId (version): " + checkoutSummaryId);
            }
            String cartId = parts[1];
            return new CartSnapshotId(VersionedId.create((String)cartId, (int)cartVersion), timeStamp, appServerId);
        }
    }
}

