/*
 * Decompiled with CFR 0.152.
 */
package sphere;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.sphere.client.CommandRequest;
import io.sphere.client.SphereClientException;
import io.sphere.client.SphereResult;
import io.sphere.client.model.VersionedId;
import io.sphere.client.shop.CommentService;
import io.sphere.client.shop.CustomerService;
import io.sphere.client.shop.OrderService;
import io.sphere.client.shop.ReviewService;
import io.sphere.client.shop.model.Comment;
import io.sphere.client.shop.model.Customer;
import io.sphere.client.shop.model.CustomerToken;
import io.sphere.client.shop.model.CustomerUpdate;
import io.sphere.client.shop.model.Order;
import io.sphere.client.shop.model.Review;
import io.sphere.internal.util.Log;
import javax.annotation.Nullable;
import net.jcip.annotations.ThreadSafe;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import sphere.QueryRequest;
import sphere.Session;
import sphere.util.Async;

@ThreadSafe
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class CurrentCustomer {
    private final Session session;
    private final CustomerService customerService;
    private final OrderService orderService;
    private final CommentService commentService;
    private final ReviewService reviewService;

    private CurrentCustomer(Session session, CustomerService customerService, OrderService orderService, CommentService commentService, ReviewService reviewService) {
        this.session = session;
        this.customerService = customerService;
        this.orderService = orderService;
        this.commentService = commentService;
        this.reviewService = reviewService;
    }

    private VersionedId getIdAndVersion() {
        VersionedId sessionCustomerId = this.session.getCustomerId();
        if (sessionCustomerId != null) {
            return sessionCustomerId;
        }
        throw new SphereClientException("This CurrentCustomer instance is not valid anymore. Please don't hold references to CurrentCustomer instances after calling logout(). Instead, always use SphereClient.currentCustomer() to get an up-to-date instance, or null.");
    }

    public static CurrentCustomer createFromSession(CustomerService customerService, OrderService orderService, CommentService commentService, ReviewService reviewService) {
        Session session = Session.current();
        VersionedId sessionCustomerId = session.getCustomerId();
        if (sessionCustomerId == null) {
            return null;
        }
        return new CurrentCustomer(session, customerService, orderService, commentService, reviewService);
    }

    public Customer fetch() {
        return Async.await(this.fetchAsync());
    }

    public F.Promise<Customer> fetchAsync() {
        VersionedId customerId = this.getIdAndVersion();
        Log.trace((String)String.format("[customer] Fetching customer %s.", customerId.getId()));
        return Async.asPlayPromise(Futures.transform((ListenableFuture)this.customerService.byId(customerId.getId()).expand(new String[]{"customerGroup"}).fetchAsync(), (Function)new Function<Optional<Customer>, Customer>(){

            public Customer apply(@Nullable Optional<Customer> customer) {
                assert (customer != null);
                if (!customer.isPresent()) {
                    CurrentCustomer.this.session.clearCustomer();
                    return new Customer("", 0);
                }
                return (Customer)customer.get();
            }
        }));
    }

    public void changePassword(String currentPassword, String newPassword) {
        Async.awaitResult(this.changePasswordAsync(currentPassword, newPassword));
    }

    public F.Promise<SphereResult<Customer>> changePasswordAsync(String currentPassword, String newPassword) {
        VersionedId idV = this.getIdAndVersion();
        return Async.asPlayPromise(this.executeAsync((CommandRequest<Customer>)this.customerService.changePassword(idV, currentPassword, newPassword), String.format("[customer] Changing password for customer %s.", idV.getId())));
    }

    public Customer update(CustomerUpdate update) {
        return Async.awaitResult(this.updateAsync(update));
    }

    public F.Promise<SphereResult<Customer>> updateAsync(CustomerUpdate update) {
        VersionedId idV = this.getIdAndVersion();
        return Async.asPlayPromise(this.executeAsync((CommandRequest<Customer>)this.customerService.update(idV, update), String.format("[customer] Updating customer %s.", idV.getId())));
    }

    public CustomerToken createEmailVerificationToken(int ttlMinutes) {
        return Async.awaitResult(this.createEmailVerificationTokenAsync(ttlMinutes));
    }

    public F.Promise<SphereResult<CustomerToken>> createEmailVerificationTokenAsync(int ttlMinutes) {
        VersionedId idV = this.getIdAndVersion();
        Log.trace((String)String.format("[customer] Creating email verification token for customer %s.", idV.getId()));
        return Async.execute(this.customerService.createEmailVerificationToken(idV, ttlMinutes));
    }

    public Customer confirmEmail(String token) {
        return Async.awaitResult(this.confirmEmailAsync(token));
    }

    public F.Promise<SphereResult<Customer>> confirmEmailAsync(String token) {
        VersionedId idV = this.getIdAndVersion();
        return Async.asPlayPromise(this.executeAsync((CommandRequest<Customer>)this.customerService.confirmEmail(idV, token), String.format("[customer] Confirming email for customer %s.", idV.getId())));
    }

    public QueryRequest<Order> orders() {
        VersionedId idV = this.getIdAndVersion();
        Log.trace((String)String.format("[customer] Getting orders of customer %s.", idV.getId()));
        return Async.adapt(this.orderService.forCustomer(idV.getId()));
    }

    public QueryRequest<Review> reviews() {
        VersionedId idV = this.getIdAndVersion();
        Log.trace((String)String.format("[customer] Getting reviews of customer %s.", idV.getId()));
        return Async.adapt(this.reviewService.forCustomer(idV.getId()));
    }

    public QueryRequest<Review> reviewsForProduct(String productId) {
        VersionedId idV = this.getIdAndVersion();
        Log.trace((String)String.format("[customer] Getting reviews of customer %s on a product.", idV.getId(), productId));
        return Async.adapt(this.reviewService.forCustomerAndProduct(idV.getId(), productId));
    }

    public Review createReview(String productId, String authorName, String title, String text, Double score) {
        return Async.awaitResult(this.createReviewAsync(productId, authorName, title, text, score));
    }

    public F.Promise<SphereResult<Review>> createReviewAsync(String productId, String authorName, String title, String text, Double score) {
        VersionedId idV = this.getIdAndVersion();
        Log.trace((String)String.format("[customer] Creating a review for customer %s.", idV.getId()));
        return Async.execute(this.reviewService.createReview(productId, idV.getId(), authorName, title, text, score));
    }

    public QueryRequest<Comment> comments() {
        VersionedId idV = this.getIdAndVersion();
        Log.trace((String)String.format("[customer] Getting comments of customer %s.", idV.getId()));
        return Async.adapt(this.commentService.forCustomer(idV.getId()));
    }

    public Comment createComment(String productId, String authorName, String title, String text) {
        return Async.awaitResult(this.createCommentAsync(productId, authorName, title, text));
    }

    public F.Promise<SphereResult<Comment>> createCommentAsync(String productId, String authorName, String title, String text) {
        VersionedId idV = this.getIdAndVersion();
        Log.trace((String)String.format("[customer] Creating a comment for customer %s.", idV.getId()));
        return Async.execute(this.commentService.createComment(productId, idV.getId(), authorName, title, text));
    }

    private ListenableFuture<SphereResult<Customer>> executeAsync(CommandRequest<Customer> commandRequest, String logMessage) {
        Log.trace((String)logMessage);
        return Session.withCustomerIdAndVersion((ListenableFuture<SphereResult<Customer>>)commandRequest.executeAsync(), this.session);
    }
}

