/*
 * Decompiled with CFR 0.152.
 */
package sphere;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.sphere.client.SphereResult;
import io.sphere.client.model.VersionedId;
import io.sphere.client.shop.SignInResult;
import io.sphere.client.shop.model.Cart;
import io.sphere.client.shop.model.Customer;
import javax.annotation.Nullable;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.Http;
import sphere.util.SessionUtil;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class Session {
    private final Http.Session httpSession;

    public Session(Http.Session httpSession) {
        this.httpSession = httpSession;
    }

    public Http.Session getHttpSession() {
        return this.httpSession;
    }

    public static Session current() {
        return new Session(Http.Context.current().session());
    }

    static ListenableFuture<SphereResult<Customer>> withCustomerIdAndVersion(ListenableFuture<SphereResult<Customer>> future, final Session session) {
        return Futures.transform(future, (Function)new Function<SphereResult<Customer>, SphereResult<Customer>>(){

            public SphereResult<Customer> apply(SphereResult<Customer> customer) {
                if (customer.isSuccess()) {
                    session.putCustomer((Customer)customer.getValue());
                }
                return customer;
            }
        });
    }

    static ListenableFuture<SphereResult<SignInResult>> withCustomerAndCart(ListenableFuture<SphereResult<SignInResult>> future, final Session session) {
        return Futures.transform(future, (Function)new Function<SphereResult<SignInResult>, SphereResult<SignInResult>>(){

            public SphereResult<SignInResult> apply(@Nullable SphereResult<SignInResult> customerWithCart) {
                if (customerWithCart.isSuccess()) {
                    Customer customer = ((SignInResult)customerWithCart.getValue()).getCustomer();
                    Cart cart = ((SignInResult)customerWithCart.getValue()).getCart();
                    session.putCustomer(customer);
                    if (cart != null) {
                        session.putCart(cart);
                    }
                }
                return customerWithCart;
            }
        });
    }

    @Nullable
    public VersionedId getCartId() {
        return SessionUtil.getIdOrNull(this.httpSession, "ctid", "ctv");
    }

    public Cart putCart(Cart cart) {
        SessionUtil.putIdAndVersion(this.httpSession, cart.getIdAndVersion(), "ctid", "ctv");
        SessionUtil.putInt(this.httpSession, "ctq", cart.getTotalQuantity());
        return cart;
    }

    @Nullable
    public Integer getCartTotalQuantity() {
        return SessionUtil.getIntOrNull(this.httpSession, "ctq");
    }

    public void clearCart() {
        SessionUtil.clearId(this.httpSession, "ctid", "ctv");
        SessionUtil.clear(this.httpSession, "ctq");
    }

    @Nullable
    public VersionedId getCustomerId() {
        return SessionUtil.getIdOrNull(this.httpSession, "uid", "uv");
    }

    public Customer putCustomer(Customer customer) {
        if (customer == null) {
            return null;
        }
        SessionUtil.putIdAndVersion(this.httpSession, customer.getIdAndVersion(), "uid", "uv");
        return customer;
    }

    public void clearCustomer() {
        SessionUtil.clearId(this.httpSession, "uid", "uv");
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    static class Keys {
        public static final String cartId = "ctid";
        public static final String cartVersion = "ctv";
        public static final String cartQuantity = "ctq";
        public static final String customerId = "uid";
        public static final String customerVersion = "uv";

        Keys() {
        }
    }
}

