/*
 * Decompiled with CFR 0.152.
 */
package sphere;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.ListenableFuture;
import io.sphere.client.SphereResult;
import io.sphere.client.model.VersionedId;
import io.sphere.client.shop.CategoryTree;
import io.sphere.client.shop.SignInResult;
import io.sphere.client.shop.SignUpBuilder;
import io.sphere.client.shop.SphereClient;
import io.sphere.client.shop.SphereClientConfig;
import io.sphere.client.shop.model.Cart;
import io.sphere.client.shop.model.CustomerName;
import io.sphere.internal.ChaosMode;
import io.sphere.internal.util.Log;
import io.sphere.internal.util.Util;
import java.util.Currency;
import javax.annotation.Nonnull;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import sphere.CommentService;
import sphere.Config;
import sphere.CurrentCart;
import sphere.CurrentCustomer;
import sphere.CustomObjectService;
import sphere.CustomerService;
import sphere.InventoryService;
import sphere.OrderService;
import sphere.ProductService;
import sphere.ReviewService;
import sphere.Session;
import sphere.ShippingMethodService;
import sphere.SphereConfig;
import sphere.internal.CommentServiceAdapter;
import sphere.internal.CustomObjectServiceAdapter;
import sphere.internal.CustomerServiceAdapter;
import sphere.internal.InventoryServiceAdapter;
import sphere.internal.OrderServiceAdapter;
import sphere.internal.ProductServiceAdapter;
import sphere.internal.ReviewServiceAdapter;
import sphere.internal.ShippingMethodServiceAdapter;
import sphere.util.Async;

@ThreadSafe
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class Sphere {
    private final SphereClient sphereClient;
    private final Currency cartCurrency;
    private final Cart.InventoryMode cartInventoryMode;
    private final ProductService products;
    private final CategoryTree categories;
    private final OrderService orders;
    private final CustomerService customers;
    private final ReviewService reviews;
    private final CommentService comments;
    private final InventoryService inventory;
    private final ShippingMethodService shippingMethods;
    private final CustomObjectService customObjects;
    private static Object instanceLock = new Object();
    @GuardedBy(value="clientLock")
    private static volatile Sphere instance;

    public ProductService products() {
        return this.products;
    }

    public CategoryTree categories() {
        return this.categories;
    }

    public OrderService orders() {
        return this.orders;
    }

    public CustomerService customers() {
        return this.customers;
    }

    public ReviewService reviews() {
        return this.reviews;
    }

    public CommentService comments() {
        return this.comments;
    }

    public InventoryService inventory() {
        return this.inventory;
    }

    public ShippingMethodService shippingMethods() {
        return this.shippingMethods;
    }

    public CustomObjectService customObjects() {
        return this.customObjects;
    }

    Sphere(Config sphereConfig, SphereClient sphereClient) {
        this.cartCurrency = sphereConfig.cartCurrency();
        this.cartInventoryMode = sphereConfig.cartInventoryMode();
        this.sphereClient = sphereClient;
        this.categories = this.sphereClient.categories();
        this.products = new ProductServiceAdapter(this.sphereClient.products(), sphereClient.getConfig().getDefaultLocale());
        this.orders = new OrderServiceAdapter(this.sphereClient.orders());
        this.customers = new CustomerServiceAdapter(this.sphereClient.customers());
        this.comments = new CommentServiceAdapter(this.sphereClient.comments());
        this.reviews = new ReviewServiceAdapter(this.sphereClient.reviews());
        this.inventory = new InventoryServiceAdapter(this.sphereClient.inventory());
        this.shippingMethods = new ShippingMethodServiceAdapter(this.sphereClient.shippingMethods());
        this.customObjects = new CustomObjectServiceAdapter(this.sphereClient.customObjects());
    }

    public SphereClient client() {
        return this.sphereClient;
    }

    @Nonnull
    public CurrentCart currentCart() {
        return new CurrentCart(this.sphereClient.carts(), this.sphereClient.orders(), this.cartCurrency, this.cartInventoryMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sphere getInstance() {
        Sphere result = instance;
        if (result == null) {
            Object object = instanceLock;
            synchronized (object) {
                result = instance;
                if (result == null) {
                    instance = result = Sphere.create();
                    Sphere.initChaosLevel();
                }
            }
        }
        return result;
    }

    private static Sphere create() {
        try {
            SphereConfig config = SphereConfig.root();
            return new Sphere(SphereConfig.root(), SphereClient.create((SphereClientConfig)config.createSphereClientConfig()));
        }
        catch (Exception e) {
            throw Util.toSphereException((Throwable)e);
        }
    }

    private static void initChaosLevel() {
        ChaosMode.setChaosLevel((int)SphereConfig.root().chaosLevel());
    }

    public boolean isLoggedIn() {
        return this.currentCustomer() != null;
    }

    public CurrentCustomer currentCustomer() {
        return CurrentCustomer.createFromSession(this.sphereClient.customers(), this.sphereClient.orders(), this.sphereClient.comments(), this.sphereClient.reviews());
    }

    public boolean login(String email, String password) {
        return Async.await(this.loginAsync(email, password)).isSuccess();
    }

    public F.Promise<SphereResult<SignInResult>> loginAsync(String email, String password) {
        if (Strings.isNullOrEmpty((String)email) || Strings.isNullOrEmpty((String)password)) {
            throw new IllegalArgumentException("Please provide a non-empty email and password.");
        }
        Log.trace((String)String.format("[login] Logging in user with email %s.", email));
        Session session = Session.current();
        VersionedId sessionCartId = session.getCartId();
        ListenableFuture loginFuture = sessionCartId == null ? this.sphereClient.customers().signIn(email, password).executeAsync() : this.sphereClient.customers().signIn(email, password, sessionCartId.getId()).executeAsync();
        return Async.asPlayPromise(Session.withCustomerAndCart((ListenableFuture<SphereResult<SignInResult>>)loginFuture, session));
    }

    public SignInResult signup(String email, String password, CustomerName customerName) {
        return Async.awaitResult(this.signupAsync(new SignUpBuilder(email, password, customerName)));
    }

    public SignInResult signup(SignUpBuilder signUpBuilder) {
        return Async.awaitResult(this.signupAsync(signUpBuilder));
    }

    public F.Promise<SphereResult<SignInResult>> signupAsync(String email, String password, CustomerName customerName) {
        return this.signupAsync(new SignUpBuilder(email, password, customerName));
    }

    public F.Promise<SphereResult<SignInResult>> signupAsync(SignUpBuilder signUpBuilder) {
        Log.trace((String)String.format("[signup] Signing up user with email %s.", signUpBuilder.getEmail()));
        Session session = Session.current();
        String anonymousCartId = session.getCartId() != null ? session.getCartId().getId() : null;
        ListenableFuture signupFuture = this.sphereClient.customers().signUp(signUpBuilder.setAnonymousCartId(anonymousCartId)).executeAsync();
        return Async.asPlayPromise(Session.withCustomerAndCart((ListenableFuture<SphereResult<SignInResult>>)signupFuture, session));
    }

    public void logout() {
        Session session = Session.current();
        session.clearCustomer();
        session.clearCart();
    }
}

