/*
 * Decompiled with CFR 0.152.
 */
package sphere;

import com.google.common.base.Joiner;
import io.sphere.client.SphereClientException;
import io.sphere.client.shop.ApiMode;
import io.sphere.client.shop.SphereClientConfig;
import io.sphere.client.shop.model.Cart;
import io.sphere.internal.util.Util;
import java.util.Currency;
import java.util.Locale;
import play.Configuration;
import play.core.enhancers.PropertiesEnhancer;
import sphere.Config;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
class SphereConfig
implements Config {
    private static final String configPrefix = "sphere";
    private final Configuration sphereConfig;
    private static final SphereConfig instance = new SphereConfig(Configuration.root());

    public static SphereConfig root() {
        return instance;
    }

    public SphereClientConfig createSphereClientConfig() {
        String localeString = this.sphereConfig.getString("defaultLocale", "en");
        Locale locale = Util.fromLanguageTag((String)localeString);
        return new SphereClientConfig.Builder(this.project(), this.clientId(), this.clientSecret(), locale).setCoreHttpServiceUrl(this.coreEndpoint()).setAuthHttpServiceUrl(this.authEndpoint()).setApiMode(this.apiMode()).build();
    }

    SphereConfig(Configuration playConfig) {
        this.sphereConfig = playConfig.getConfig(configPrefix);
    }

    public String coreEndpoint() {
        return this.getStringOrThrow("core");
    }

    public String authEndpoint() {
        return this.getStringOrThrow("auth");
    }

    public String project() {
        String value = this.getStringOrThrow("project");
        try {
            SphereClientConfig.validateProjectKey((String)value);
            return value;
        }
        catch (SphereClientException e) {
            throw this.sphereConfig.reportError("project", e.getMessage(), (Throwable)e);
        }
    }

    public String clientId() {
        return this.getStringOrThrow("clientId");
    }

    public String clientSecret() {
        return this.getStringOrThrow("clientSecret");
    }

    public int chaosLevel() {
        Integer value = this.sphereConfig.getInt("chaosLevel");
        return value == null ? 0 : Math.min(Math.max(value, 0), 5);
    }

    public ApiMode apiMode() {
        String value = this.sphereConfig.getString("products.mode");
        if (value == null) {
            return ApiMode.Published;
        }
        if (value.toLowerCase().equals("published")) {
            return ApiMode.Published;
        }
        if (value.toLowerCase().equals("staged")) {
            return ApiMode.Staged;
        }
        throw this.sphereConfig.reportError("products.mode", "'sphere.products.mode' must be \"published\" or \"staged\". Was \"" + value + "\".", null);
    }

    @Override
    public Cart.InventoryMode cartInventoryMode() {
        String value = this.sphereConfig.getString("cart.inventoryMode");
        if (value == null) {
            return Cart.InventoryMode.None;
        }
        try {
            return Cart.InventoryMode.valueOf((String)value);
        }
        catch (IllegalArgumentException e) {
            throw this.sphereConfig.reportError("cart.inventoryMode", "Invalid value for cart.inventoryMode: '" + value + "'. " + "Valid values are: " + Joiner.on((String)", ").join((Object[])Cart.InventoryMode.values()), (Throwable)e);
        }
    }

    @Override
    public Currency cartCurrency() {
        String currencyCode = this.getStringOrThrow("cart.currency");
        try {
            return Currency.getInstance(currencyCode);
        }
        catch (Exception e) {
            throw this.sphereConfig.reportError("cart.currency", "'sphere." + currencyCode + "' is not a valid ISO 4217 currency code.", (Throwable)e);
        }
    }

    private String getStringOrThrow(String key) {
        String value = this.sphereConfig.getString(key);
        if (value == null) {
            throw this.sphereConfig.reportError(key, "Path 'sphere." + key + "' not found in configuration.", null);
        }
        if (value.equals("")) {
            throw this.sphereConfig.reportError(key, "Path 'sphere." + key + "' can't be empty in configuration.", null);
        }
        return value;
    }
}

