/*
 * Decompiled with CFR 0.152.
 */
package sphere.internal;

import io.sphere.client.SphereResult;
import io.sphere.client.model.VersionedId;
import io.sphere.client.shop.model.Comment;
import io.sphere.client.shop.model.CommentUpdate;
import javax.annotation.Nonnull;
import net.jcip.annotations.Immutable;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import sphere.CommentService;
import sphere.FetchRequest;
import sphere.QueryRequest;
import sphere.util.Async;

@Immutable
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class CommentServiceAdapter
implements CommentService {
    private final io.sphere.client.shop.CommentService service;

    public CommentServiceAdapter(@Nonnull io.sphere.client.shop.CommentService service) {
        if (service == null) {
            throw new NullPointerException("service");
        }
        this.service = service;
    }

    @Override
    public FetchRequest<Comment> byId(String id) {
        return Async.adapt(this.service.byId(id));
    }

    @Override
    @Deprecated
    public QueryRequest<Comment> all() {
        return this.query();
    }

    @Override
    public QueryRequest<Comment> query() {
        return Async.adapt(this.service.query());
    }

    @Override
    public QueryRequest<Comment> byProductId(String productId) {
        return Async.adapt(this.service.forProduct(productId));
    }

    @Override
    public Comment updateComment(VersionedId commentId, CommentUpdate update) {
        return Async.awaitResult(this.updateCommentAsync(commentId, update));
    }

    @Override
    public F.Promise<SphereResult<Comment>> updateCommentAsync(VersionedId commentId, CommentUpdate update) {
        return Async.execute(this.service.updateComment(commentId, update));
    }
}

