/*
 * Decompiled with CFR 0.152.
 */
package sphere.internal;

import io.sphere.client.SphereResult;
import io.sphere.client.model.VersionedId;
import io.sphere.client.shop.model.Customer;
import io.sphere.client.shop.model.CustomerToken;
import javax.annotation.Nonnull;
import net.jcip.annotations.Immutable;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import sphere.CustomerService;
import sphere.FetchRequest;
import sphere.util.Async;

@Immutable
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class CustomerServiceAdapter
implements CustomerService {
    private final io.sphere.client.shop.CustomerService service;

    public CustomerServiceAdapter(@Nonnull io.sphere.client.shop.CustomerService service) {
        if (service == null) {
            throw new NullPointerException("service");
        }
        this.service = service;
    }

    @Override
    public FetchRequest<Customer> byToken(String token) {
        return Async.adapt(this.service.byToken(token));
    }

    @Override
    public CustomerToken createPasswordResetToken(String email) {
        return Async.awaitResult(this.createPasswordResetTokenAsync(email));
    }

    @Override
    public F.Promise<SphereResult<CustomerToken>> createPasswordResetTokenAsync(String email) {
        return Async.execute(this.service.createPasswordResetToken(email));
    }

    @Override
    public Customer resetPassword(VersionedId customerId, String token, String newPassword) {
        return (Customer)this.service.resetPassword(customerId, token, newPassword).execute();
    }

    @Override
    public F.Promise<SphereResult<Customer>> resetPasswordAsync(VersionedId customerId, String token, String newPassword) {
        return Async.execute(this.service.resetPassword(customerId, token, newPassword));
    }
}

