/*
 * Decompiled with CFR 0.152.
 */
package sphere.internal;

import io.sphere.client.SphereResult;
import io.sphere.client.model.VersionedId;
import io.sphere.client.shop.model.Order;
import io.sphere.client.shop.model.OrderUpdate;
import io.sphere.client.shop.model.PaymentState;
import io.sphere.client.shop.model.ShipmentState;
import javax.annotation.Nonnull;
import net.jcip.annotations.Immutable;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import sphere.FetchRequest;
import sphere.OrderService;
import sphere.QueryRequest;
import sphere.util.Async;

@Immutable
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class OrderServiceAdapter
implements OrderService {
    private final io.sphere.client.shop.OrderService service;

    public OrderServiceAdapter(@Nonnull io.sphere.client.shop.OrderService service) {
        if (service == null) {
            throw new NullPointerException("service");
        }
        this.service = service;
    }

    @Override
    public FetchRequest<Order> byId(String id) {
        return Async.adapt(this.service.byId(id));
    }

    @Override
    @Deprecated
    public QueryRequest<Order> all() {
        return this.query();
    }

    @Override
    public QueryRequest<Order> query() {
        return Async.adapt(this.service.query());
    }

    @Override
    @Deprecated
    public Order updatePaymentState(VersionedId orderId, PaymentState paymentState) {
        return this.updateOrder(orderId, new OrderUpdate().setPaymentState(paymentState));
    }

    @Override
    @Deprecated
    public F.Promise<SphereResult<Order>> updatePaymentStateAsync(VersionedId orderId, PaymentState paymentState) {
        return this.updateOrderAsync(orderId, new OrderUpdate().setPaymentState(paymentState));
    }

    @Override
    @Deprecated
    public Order updateShipmentState(VersionedId orderId, ShipmentState shipmentState) {
        return this.updateOrder(orderId, new OrderUpdate().setShipmentState(shipmentState));
    }

    @Override
    @Deprecated
    public F.Promise<SphereResult<Order>> updateShipmentStateAsync(VersionedId orderId, ShipmentState shipmentState) {
        return this.updateOrderAsync(orderId, new OrderUpdate().setShipmentState(shipmentState));
    }

    @Override
    public Order updateOrder(VersionedId orderId, OrderUpdate orderUpdate) {
        return Async.awaitResult(this.updateOrderAsync(orderId, orderUpdate));
    }

    @Override
    public F.Promise<SphereResult<Order>> updateOrderAsync(VersionedId orderId, OrderUpdate orderUpdate) {
        return Async.execute(this.service.updateOrder(orderId, orderUpdate));
    }
}

