/*
 * Decompiled with CFR 0.152.
 */
package sphere.internal;

import io.sphere.client.filters.expressions.FilterExpression;
import io.sphere.client.shop.model.Product;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.jcip.annotations.Immutable;
import play.core.enhancers.PropertiesEnhancer;
import sphere.FetchRequest;
import sphere.ProductService;
import sphere.SearchRequest;
import sphere.util.Async;

@Immutable
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class ProductServiceAdapter
implements ProductService {
    private final io.sphere.client.shop.ProductService service;
    private final Locale defaultLocale;

    public ProductServiceAdapter(@Nonnull io.sphere.client.shop.ProductService service, @Nonnull Locale defaultLocale) {
        if (service == null) {
            throw new NullPointerException("service");
        }
        if (defaultLocale == null) {
            throw new NullPointerException("defaultLocale");
        }
        this.service = service;
        this.defaultLocale = defaultLocale;
    }

    @Override
    public FetchRequest<Product> byId(String id) {
        return Async.adapt(this.service.byId(id));
    }

    @Override
    public FetchRequest<Product> bySlug(Locale locale, String slug) {
        return Async.adapt(this.service.bySlug(locale, slug));
    }

    @Override
    public FetchRequest<Product> bySlug(String slug) {
        return Async.adapt(this.service.bySlug(this.defaultLocale, slug));
    }

    @Override
    public SearchRequest<Product> all(Locale locale) {
        return Async.adapt(this.service.all(locale));
    }

    @Override
    public SearchRequest<Product> all() {
        return this.all(this.defaultLocale);
    }

    @Override
    public SearchRequest<Product> filter(Locale locale, FilterExpression filter, FilterExpression ... filters) {
        return Async.adapt(this.service.filter(locale, filter, filters));
    }

    @Override
    public SearchRequest<Product> filter(FilterExpression filter, FilterExpression ... filters) {
        return this.filter(this.defaultLocale, filter, filters);
    }

    @Override
    public SearchRequest<Product> filter(Locale locale, Iterable<FilterExpression> filters) {
        return Async.adapt(this.service.filter(locale, filters));
    }

    @Override
    public SearchRequest<Product> filter(Iterable<FilterExpression> filters) {
        return this.filter(this.defaultLocale, filters);
    }
}

