/*
 * Decompiled with CFR 0.152.
 */
package sphere.internal;

import io.sphere.client.SphereResult;
import io.sphere.client.model.VersionedId;
import io.sphere.client.shop.model.Review;
import io.sphere.client.shop.model.ReviewUpdate;
import javax.annotation.Nonnull;
import net.jcip.annotations.Immutable;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import sphere.FetchRequest;
import sphere.QueryRequest;
import sphere.ReviewService;
import sphere.util.Async;

@Immutable
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class ReviewServiceAdapter
implements ReviewService {
    private final io.sphere.client.shop.ReviewService service;

    public ReviewServiceAdapter(@Nonnull io.sphere.client.shop.ReviewService service) {
        if (service == null) {
            throw new NullPointerException("service");
        }
        this.service = service;
    }

    @Override
    public FetchRequest<Review> byId(String id) {
        return Async.adapt(this.service.byId(id));
    }

    @Override
    @Deprecated
    public QueryRequest<Review> all() {
        return Async.adapt(this.service.query());
    }

    @Override
    public QueryRequest<Review> query() {
        return Async.adapt(this.service.query());
    }

    @Override
    public QueryRequest<Review> byProductId(String productId) {
        return Async.adapt(this.service.forProduct(productId));
    }

    @Override
    public Review updateReview(VersionedId reviewId, ReviewUpdate update) {
        return Async.awaitResult(this.updateReviewAsync(reviewId, update));
    }

    @Override
    public F.Promise<SphereResult<Review>> updateReviewAsync(VersionedId reviewId, ReviewUpdate update) {
        return Async.execute(this.service.updateReview(reviewId, update));
    }
}

