/*
 * Decompiled with CFR 0.152.
 */
package sphere.util;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.sphere.client.CommandRequest;
import io.sphere.client.SphereResult;
import io.sphere.internal.util.Util;
import java.util.concurrent.TimeUnit;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.mvc.Result;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import sphere.DeleteRequest;
import sphere.FetchRequest;
import sphere.QueryRequest;
import sphere.SearchRequest;
import sphere.internal.DeleteRequestAdapter;
import sphere.internal.FetchRequestAdapter;
import sphere.internal.QueryRequestAdapter;
import sphere.internal.SearchRequestAdapter;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public final class Async {
    private Async() {
    }

    public static F.Promise<Result> asyncResult(ListenableFuture<Result> resultFuture) {
        return Async.asPlayPromise(resultFuture);
    }

    public static <T> F.Promise<T> asPlayPromise(ListenableFuture<T> future) {
        return F.Promise.wrap(Async.asScalaFuture(future));
    }

    private static <T> Future<T> asScalaFuture(ListenableFuture<T> future) {
        final Promise promise = play.api.libs.concurrent.Promise.apply();
        Futures.addCallback(future, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
                promise.success(result);
            }

            public void onFailure(Throwable t) {
                promise.failure(t);
            }
        });
        return promise.future();
    }

    public static <T> T await(F.Promise<T> promise) {
        try {
            return (T)promise.get(30L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw Util.toSphereException((Throwable)e);
        }
    }

    public static <T> T awaitResult(F.Promise<SphereResult<T>> promise) {
        SphereResult<T> result = Async.await(promise);
        return (T)Util.getValueOrThrow(result);
    }

    public static <T> F.Promise<SphereResult<T>> execute(CommandRequest<T> req) {
        return Async.asPlayPromise(req.executeAsync());
    }

    public static <T> FetchRequest<T> adapt(io.sphere.client.FetchRequest<T> req) {
        return new FetchRequestAdapter<T>(req);
    }

    public static <T> DeleteRequest<T> adapt(io.sphere.client.DeleteRequest<T> req) {
        return new DeleteRequestAdapter<T>(req);
    }

    public static <T> QueryRequest<T> adapt(io.sphere.client.QueryRequest<T> req) {
        return new QueryRequestAdapter<T>(req);
    }

    public static <T> SearchRequest<T> adapt(io.sphere.client.SearchRequest<T> req) {
        return new SearchRequestAdapter<T>(req);
    }
}

