/*
 * Decompiled with CFR 0.152.
 */
package sphere.util;

import com.google.common.base.Function;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import javax.annotation.Nonnull;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class RecoverFuture<V>
extends AbstractFuture<V>
implements FutureCallback<V> {
    @Nonnull
    private final Function<Throwable, V> catcher;

    private RecoverFuture(@Nonnull Function<Throwable, V> catcher) {
        if (catcher == null) {
            throw new NullPointerException("catcher");
        }
        this.catcher = catcher;
    }

    public static <V> ListenableFuture<V> recover(@Nonnull ListenableFuture<V> future, @Nonnull Function<Throwable, V> catcher) {
        if (future == null) {
            throw new NullPointerException("future");
        }
        if (catcher == null) {
            throw new NullPointerException("catcher");
        }
        RecoverFuture<V> recoverFuture = new RecoverFuture<V>(catcher);
        Futures.addCallback(future, recoverFuture);
        return recoverFuture;
    }

    public void onSuccess(V result) {
        this.set(result);
    }

    public void onFailure(Throwable t) {
        Object result = null;
        boolean success = false;
        try {
            result = this.catcher.apply((Object)t);
            success = true;
        }
        catch (Throwable e) {
            this.setException(e);
        }
        if (success) {
            this.set(result);
        }
    }
}

