/*
 * Decompiled with CFR 0.152.
 */
package sphere.util;

import com.google.common.base.Strings;
import io.sphere.client.model.VersionedId;
import io.sphere.internal.util.Log;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.Http;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class SessionUtil {
    public static void putInt(Http.Session session, String key, int value) {
        Log.trace((String)("SessionUtil.putInt: " + key + ":" + Integer.valueOf(value)));
        session.put(key, String.valueOf(value));
    }

    public static void putString(Http.Session session, String key, String value) {
        Log.trace((String)("SessionUtil.putString: " + key + ":" + value));
        session.put(key, value);
    }

    public static Integer getIntOrNull(Http.Session session, String key) {
        String value = (String)session.get((Object)key);
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    public static void clear(Http.Session session, String key) {
        Log.trace((String)("SessionUtil.clear: " + key));
        session.remove((Object)key);
    }

    public static VersionedId getIdOrNull(Http.Session session, String idKey, String versionKey) {
        String id = (String)session.get((Object)idKey);
        String version = (String)session.get((Object)versionKey);
        if (Strings.isNullOrEmpty((String)id) || Strings.isNullOrEmpty((String)version)) {
            return null;
        }
        try {
            return VersionedId.create((String)id, (int)Integer.parseInt(version));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    public static void putIdAndVersion(Http.Session session, VersionedId versionedId, String idKey, String versionKey) {
        SessionUtil.putString(session, idKey, versionedId.getId());
        SessionUtil.putString(session, versionKey, Integer.toString(versionedId.getVersion()));
    }

    public static void clearId(Http.Session session, String idKey, String versionKey) {
        SessionUtil.clear(session, idKey);
        SessionUtil.clear(session, versionKey);
    }
}

