/*
 * Decompiled with CFR 0.152.
 */
package io.spiffe;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum Algorithm {
    ES256("ES256"),
    ES384("ES384"),
    ES512("ES512"),
    RS256("RS256"),
    RS384("RS384"),
    RS512("RS512"),
    PS256("PS256"),
    PS384("PS384"),
    PS512("PS512"),
    OTHER("OTHER");

    private final String name;

    private Algorithm(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static Algorithm parse(String s) {
        Algorithm algorithm = s.equals(RS256.getName()) ? RS256 : (s.equals(RS384.getName()) ? RS384 : (s.equals(RS512.getName()) ? RS512 : (s.equals(ES256.getName()) ? ES256 : (s.equals(ES384.getName()) ? ES384 : (s.equals(ES512.getName()) ? ES512 : (s.equals(PS256.getName()) ? PS256 : (s.equals(PS384.getName()) ? PS384 : (s.equals(PS512.getName()) ? PS512 : OTHER))))))));
        return algorithm;
    }

    public static enum Family {
        RSA("RSA", RS256, RS384, RS512, PS256, PS384, PS512),
        EC("EC", ES256, ES384, ES512),
        OTHER("UNKNOWN", new Algorithm[0]);

        private final String name;
        private final Set<Algorithm> algorithms;

        private Family(String name, Algorithm ... algs) {
            this.name = name;
            this.algorithms = new HashSet<Algorithm>();
            Collections.addAll(this.algorithms, algs);
        }

        public String getName() {
            return this.name;
        }

        public boolean contains(Algorithm a) {
            return this.algorithms.contains((Object)a);
        }

        public static Family parse(String s) {
            Family family = s.equals(RSA.getName()) ? RSA : (s.equals(EC.getName()) ? EC : OTHER);
            return family;
        }
    }
}

