/*
 * Decompiled with CFR 0.152.
 */
package io.spiffe.bundle.jwtbundle;

import io.spiffe.bundle.BundleSource;
import io.spiffe.bundle.jwtbundle.JwtBundle;
import io.spiffe.exception.BundleNotFoundException;
import io.spiffe.spiffeid.TrustDomain;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import lombok.NonNull;

public final class JwtBundleSet
implements BundleSource<JwtBundle> {
    private final Map<TrustDomain, JwtBundle> bundles;

    private JwtBundleSet(Map<TrustDomain, JwtBundle> bundles) {
        this.bundles = new ConcurrentHashMap<TrustDomain, JwtBundle>(bundles);
    }

    private JwtBundleSet() {
        this.bundles = new ConcurrentHashMap<TrustDomain, JwtBundle>();
    }

    public static JwtBundleSet of(@NonNull Collection<JwtBundle> bundles) {
        if (bundles == null) {
            throw new NullPointerException("bundles is marked non-null but is null");
        }
        if (bundles.size() == 0) {
            throw new IllegalArgumentException("JwtBundle collection is empty");
        }
        ConcurrentHashMap<TrustDomain, JwtBundle> bundleMap = new ConcurrentHashMap<TrustDomain, JwtBundle>();
        for (JwtBundle bundle : bundles) {
            bundleMap.put(bundle.getTrustDomain(), bundle);
        }
        return new JwtBundleSet(bundleMap);
    }

    public static JwtBundleSet emptySet() {
        return new JwtBundleSet();
    }

    @Override
    public JwtBundle getBundleForTrustDomain(@NonNull TrustDomain trustDomain) throws BundleNotFoundException {
        if (trustDomain == null) {
            throw new NullPointerException("trustDomain is marked non-null but is null");
        }
        JwtBundle bundle = this.bundles.get(trustDomain);
        if (bundle == null) {
            throw new BundleNotFoundException(String.format("No JWT bundle for trust domain %s", trustDomain));
        }
        return bundle;
    }

    public Map<TrustDomain, JwtBundle> getBundles() {
        return Collections.unmodifiableMap(this.bundles);
    }

    public void put(@NonNull JwtBundle jwtBundle) {
        if (jwtBundle == null) {
            throw new NullPointerException("jwtBundle is marked non-null but is null");
        }
        this.bundles.put(jwtBundle.getTrustDomain(), jwtBundle);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtBundleSet)) {
            return false;
        }
        JwtBundleSet other = (JwtBundleSet)o;
        Map<TrustDomain, JwtBundle> this$bundles = this.getBundles();
        Map<TrustDomain, JwtBundle> other$bundles = other.getBundles();
        return !(this$bundles == null ? other$bundles != null : !((Object)this$bundles).equals(other$bundles));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<TrustDomain, JwtBundle> $bundles = this.getBundles();
        result = result * 59 + ($bundles == null ? 43 : ((Object)$bundles).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JwtBundleSet(bundles=" + this.getBundles() + ")";
    }
}

