/*
 * Decompiled with CFR 0.152.
 */
package io.spiffe.bundle.x509bundle;

import io.spiffe.bundle.BundleSource;
import io.spiffe.bundle.x509bundle.X509Bundle;
import io.spiffe.exception.BundleNotFoundException;
import io.spiffe.spiffeid.TrustDomain;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import lombok.NonNull;

public final class X509BundleSet
implements BundleSource<X509Bundle> {
    private final Map<TrustDomain, X509Bundle> bundles;

    private X509BundleSet(Map<TrustDomain, X509Bundle> bundles) {
        this.bundles = new ConcurrentHashMap<TrustDomain, X509Bundle>(bundles);
    }

    private X509BundleSet() {
        this.bundles = new ConcurrentHashMap<TrustDomain, X509Bundle>();
    }

    public static X509BundleSet of(@NonNull Collection<X509Bundle> bundles) {
        if (bundles == null) {
            throw new NullPointerException("bundles is marked non-null but is null");
        }
        if (bundles.size() == 0) {
            throw new IllegalArgumentException("X509Bundles collection is empty");
        }
        ConcurrentHashMap<TrustDomain, X509Bundle> bundleMap = new ConcurrentHashMap<TrustDomain, X509Bundle>();
        for (X509Bundle bundle : bundles) {
            bundleMap.put(bundle.getTrustDomain(), bundle);
        }
        return new X509BundleSet(bundleMap);
    }

    public static X509BundleSet emptySet() {
        return new X509BundleSet();
    }

    public void put(@NonNull X509Bundle x509Bundle) {
        if (x509Bundle == null) {
            throw new NullPointerException("x509Bundle is marked non-null but is null");
        }
        this.bundles.put(x509Bundle.getTrustDomain(), x509Bundle);
    }

    @Override
    public X509Bundle getBundleForTrustDomain(@NonNull TrustDomain trustDomain) throws BundleNotFoundException {
        if (trustDomain == null) {
            throw new NullPointerException("trustDomain is marked non-null but is null");
        }
        X509Bundle bundle = this.bundles.get(trustDomain);
        if (bundle == null) {
            throw new BundleNotFoundException(String.format("No X.509 bundle for trust domain %s", trustDomain));
        }
        return bundle;
    }

    public Map<TrustDomain, X509Bundle> getBundles() {
        return Collections.unmodifiableMap(this.bundles);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof X509BundleSet)) {
            return false;
        }
        X509BundleSet other = (X509BundleSet)o;
        Map<TrustDomain, X509Bundle> this$bundles = this.getBundles();
        Map<TrustDomain, X509Bundle> other$bundles = other.getBundles();
        return !(this$bundles == null ? other$bundles != null : !((Object)this$bundles).equals(other$bundles));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<TrustDomain, X509Bundle> $bundles = this.getBundles();
        result = result * 59 + ($bundles == null ? 43 : ((Object)$bundles).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "X509BundleSet(bundles=" + this.getBundles() + ")";
    }
}

