/*
 * Decompiled with CFR 0.152.
 */
package io.spiffe.spiffeid;

import io.spiffe.spiffeid.TrustDomain;
import java.net.URI;
import java.util.Arrays;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public final class SpiffeId {
    public static final String SPIFFE_SCHEME = "spiffe";
    private final TrustDomain trustDomain;
    private final String path;

    private SpiffeId(TrustDomain trustDomain, String path) {
        this.trustDomain = trustDomain;
        this.path = path;
    }

    public static SpiffeId of(@NonNull TrustDomain trustDomain, String ... segments) {
        if (trustDomain == null) {
            throw new NullPointerException("trustDomain is marked non-null but is null");
        }
        String path = Arrays.stream(segments).filter(StringUtils::isNotBlank).map(SpiffeId::normalize).map(s -> '/' + s).collect(Collectors.joining());
        return new SpiffeId(trustDomain, path);
    }

    public static SpiffeId parse(String spiffeIdAsString) {
        if (StringUtils.isBlank((CharSequence)spiffeIdAsString)) {
            throw new IllegalArgumentException("SPIFFE ID cannot be empty");
        }
        URI uri = URI.create(SpiffeId.normalize(spiffeIdAsString));
        SpiffeId.validateUri(uri);
        TrustDomain trustDomain = TrustDomain.of(uri.getHost());
        String path = uri.getPath();
        return new SpiffeId(trustDomain, path);
    }

    public boolean memberOf(TrustDomain trustDomain) {
        return this.trustDomain.equals(trustDomain);
    }

    public String toString() {
        return String.format("%s://%s%s", SPIFFE_SCHEME, this.trustDomain.toString(), this.path);
    }

    private static String normalize(String s) {
        return s.toLowerCase().trim();
    }

    private static void validateUri(URI uri) {
        String scheme = uri.getScheme();
        if (!SPIFFE_SCHEME.equals(scheme)) {
            throw new IllegalArgumentException("SPIFFE ID: invalid scheme");
        }
        if (uri.getUserInfo() != null) {
            throw new IllegalArgumentException("SPIFFE ID: user info is not allowed");
        }
        if (StringUtils.isBlank((CharSequence)uri.getHost())) {
            throw new IllegalArgumentException("SPIFFE ID: trust domain is empty");
        }
        if (uri.getPort() != -1) {
            throw new IllegalArgumentException("SPIFFE ID: port is not allowed");
        }
        if (StringUtils.isNotBlank((CharSequence)uri.getFragment())) {
            throw new IllegalArgumentException("SPIFFE ID: fragment is not allowed");
        }
        if (StringUtils.isNotBlank((CharSequence)uri.getRawQuery())) {
            throw new IllegalArgumentException("SPIFFE ID: query is not allowed");
        }
    }

    @Generated
    public TrustDomain getTrustDomain() {
        return this.trustDomain;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpiffeId)) {
            return false;
        }
        SpiffeId other = (SpiffeId)o;
        TrustDomain this$trustDomain = this.getTrustDomain();
        TrustDomain other$trustDomain = other.getTrustDomain();
        if (this$trustDomain == null ? other$trustDomain != null : !((Object)this$trustDomain).equals(other$trustDomain)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TrustDomain $trustDomain = this.getTrustDomain();
        result = result * 59 + ($trustDomain == null ? 43 : ((Object)$trustDomain).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }
}

