/*
 * Decompiled with CFR 0.152.
 */
package io.spiffe.spiffeid;

import io.spiffe.spiffeid.SpiffeId;
import java.net.URI;
import java.net.URISyntaxException;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public final class TrustDomain {
    private final String name;

    private TrustDomain(String trustDomain) {
        this.name = trustDomain;
    }

    public static TrustDomain of(@NonNull String trustDomain) {
        URI uri;
        if (trustDomain == null) {
            throw new NullPointerException("trustDomain is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)trustDomain)) {
            throw new IllegalArgumentException("Trust domain cannot be empty");
        }
        try {
            String normalized = TrustDomain.normalize(trustDomain);
            uri = new URI(normalized);
            TrustDomain.validateUri(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        String host = uri.getHost();
        TrustDomain.validateHost(host);
        return new TrustDomain(host);
    }

    public SpiffeId newSpiffeId(String ... segments) {
        return SpiffeId.of(this, segments);
    }

    public String toString() {
        return this.name;
    }

    private static void validateHost(String host) {
        if (StringUtils.isBlank((CharSequence)host)) {
            throw new IllegalArgumentException("Trust domain cannot be empty");
        }
    }

    private static void validateUri(URI uri) {
        String scheme = uri.getScheme();
        if (!"spiffe".equals(scheme)) {
            throw new IllegalArgumentException("Invalid scheme");
        }
        int port = uri.getPort();
        if (port != -1) {
            throw new IllegalArgumentException("Trust Domain: port is not allowed");
        }
    }

    private static String normalize(String s) {
        String result = s.toLowerCase().trim();
        if (!result.contains("://")) {
            result = "spiffe".concat("://").concat(result);
        }
        return result;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrustDomain)) {
            return false;
        }
        TrustDomain other = (TrustDomain)o;
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }
}

