/*
 * Decompiled with CFR 0.152.
 */
package io.spiffe.workloadapi;

import io.spiffe.bundle.jwtbundle.JwtBundle;
import io.spiffe.bundle.jwtbundle.JwtBundleSet;
import io.spiffe.exception.BundleNotFoundException;
import io.spiffe.exception.JwtSourceException;
import io.spiffe.exception.JwtSvidException;
import io.spiffe.exception.SocketEndpointAddressException;
import io.spiffe.exception.WatcherException;
import io.spiffe.spiffeid.SpiffeId;
import io.spiffe.spiffeid.TrustDomain;
import io.spiffe.svid.jwtsvid.JwtSvid;
import io.spiffe.workloadapi.DefaultWorkloadApiClient;
import io.spiffe.workloadapi.JwtSource;
import io.spiffe.workloadapi.Watcher;
import io.spiffe.workloadapi.WorkloadApiClient;
import io.spiffe.workloadapi.internal.ThreadUtils;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import lombok.NonNull;

public class DefaultJwtSource
implements JwtSource {
    @Generated
    private static final Logger log = Logger.getLogger(DefaultJwtSource.class.getName());
    static final String TIMEOUT_SYSTEM_PROPERTY = "spiffe.newJwtSource.timeout";
    static final Duration DEFAULT_TIMEOUT = Duration.parse(System.getProperty("spiffe.newJwtSource.timeout", "PT0S"));
    private JwtBundleSet bundles;
    private final WorkloadApiClient workloadApiClient;
    private volatile boolean closed;

    private DefaultJwtSource(WorkloadApiClient workloadApiClient) {
        this.workloadApiClient = workloadApiClient;
    }

    public static JwtSource newSource() throws JwtSourceException, SocketEndpointAddressException {
        JwtSourceOptions options = JwtSourceOptions.builder().initTimeout(DEFAULT_TIMEOUT).build();
        return DefaultJwtSource.newSource(options);
    }

    public static JwtSource newSource(@NonNull JwtSourceOptions options) throws SocketEndpointAddressException, JwtSourceException {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (options.workloadApiClient == null) {
            options.workloadApiClient = DefaultJwtSource.createClient(options);
        }
        if (options.initTimeout == null) {
            options.initTimeout = DefaultJwtSource.DEFAULT_TIMEOUT;
        }
        DefaultJwtSource jwtSource = new DefaultJwtSource(options.workloadApiClient);
        try {
            jwtSource.init(options.initTimeout);
        }
        catch (Exception e) {
            jwtSource.close();
            throw new JwtSourceException("Error creating JWT source", e);
        }
        return jwtSource;
    }

    @Override
    public JwtSvid fetchJwtSvid(String audience, String ... extraAudiences) throws JwtSvidException {
        if (this.isClosed()) {
            throw new IllegalStateException("JWT SVID source is closed");
        }
        return this.workloadApiClient.fetchJwtSvid(audience, extraAudiences);
    }

    @Override
    public JwtSvid fetchJwtSvid(SpiffeId subject, String audience, String ... extraAudiences) throws JwtSvidException {
        if (this.isClosed()) {
            throw new IllegalStateException("JWT SVID source is closed");
        }
        return this.workloadApiClient.fetchJwtSvid(subject, audience, extraAudiences);
    }

    @Override
    public JwtBundle getBundleForTrustDomain(@NonNull TrustDomain trustDomain) throws BundleNotFoundException {
        if (trustDomain == null) {
            throw new NullPointerException("trustDomain is marked non-null but is null");
        }
        if (this.isClosed()) {
            throw new IllegalStateException("JWT bundle source is closed");
        }
        return this.bundles.getBundleForTrustDomain(trustDomain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block6: {
            if (this.closed) break block6;
            DefaultJwtSource defaultJwtSource = this;
            synchronized (defaultJwtSource) {
                if (!this.closed) {
                    this.workloadApiClient.close();
                    this.closed = true;
                }
            }
        }
    }

    private void init(Duration timeout) throws TimeoutException {
        boolean success;
        CountDownLatch done = new CountDownLatch(1);
        this.setJwtBundlesWatcher(done);
        if (timeout.isZero()) {
            ThreadUtils.await(done);
            success = true;
        } else {
            success = ThreadUtils.await(done, timeout.getSeconds(), TimeUnit.SECONDS);
        }
        if (!success) {
            throw new TimeoutException("Timeout waiting for JWT bundles update");
        }
    }

    private void setJwtBundlesWatcher(final CountDownLatch done) {
        this.workloadApiClient.watchJwtBundles(new Watcher<JwtBundleSet>(){

            @Override
            public void onUpdate(JwtBundleSet update) {
                log.log(Level.INFO, "Received JwtBundleSet update");
                DefaultJwtSource.this.setJwtBundleSet(update);
                done.countDown();
            }

            @Override
            public void onError(Throwable error) {
                log.log(Level.SEVERE, "Error in JwtBundleSet watcher", error);
                done.countDown();
                throw new WatcherException("Error fetching JwtBundleSet", error);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setJwtBundleSet(JwtBundleSet update) {
        DefaultJwtSource defaultJwtSource = this;
        synchronized (defaultJwtSource) {
            this.bundles = update;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isClosed() {
        DefaultJwtSource defaultJwtSource = this;
        synchronized (defaultJwtSource) {
            return this.closed;
        }
    }

    private static WorkloadApiClient createClient(JwtSourceOptions options) throws SocketEndpointAddressException {
        DefaultWorkloadApiClient.ClientOptions clientOptions = DefaultWorkloadApiClient.ClientOptions.builder().spiffeSocketPath(options.spiffeSocketPath).build();
        return DefaultWorkloadApiClient.newClient(clientOptions);
    }

    public static class JwtSourceOptions {
        private String spiffeSocketPath;
        private Duration initTimeout;
        private WorkloadApiClient workloadApiClient;

        public JwtSourceOptions(String spiffeSocketPath, WorkloadApiClient workloadApiClient, Duration initTimeout) {
            this.spiffeSocketPath = spiffeSocketPath;
            this.workloadApiClient = workloadApiClient;
            this.initTimeout = initTimeout;
        }

        @Generated
        public static JwtSourceOptionsBuilder builder() {
            return new JwtSourceOptionsBuilder();
        }

        @Generated
        public String getSpiffeSocketPath() {
            return this.spiffeSocketPath;
        }

        @Generated
        public Duration getInitTimeout() {
            return this.initTimeout;
        }

        @Generated
        public WorkloadApiClient getWorkloadApiClient() {
            return this.workloadApiClient;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JwtSourceOptions)) {
                return false;
            }
            JwtSourceOptions other = (JwtSourceOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$spiffeSocketPath = this.getSpiffeSocketPath();
            String other$spiffeSocketPath = other.getSpiffeSocketPath();
            if (this$spiffeSocketPath == null ? other$spiffeSocketPath != null : !this$spiffeSocketPath.equals(other$spiffeSocketPath)) {
                return false;
            }
            Duration this$initTimeout = this.getInitTimeout();
            Duration other$initTimeout = other.getInitTimeout();
            if (this$initTimeout == null ? other$initTimeout != null : !((Object)this$initTimeout).equals(other$initTimeout)) {
                return false;
            }
            WorkloadApiClient this$workloadApiClient = this.getWorkloadApiClient();
            WorkloadApiClient other$workloadApiClient = other.getWorkloadApiClient();
            return !(this$workloadApiClient == null ? other$workloadApiClient != null : !this$workloadApiClient.equals(other$workloadApiClient));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JwtSourceOptions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $spiffeSocketPath = this.getSpiffeSocketPath();
            result = result * 59 + ($spiffeSocketPath == null ? 43 : $spiffeSocketPath.hashCode());
            Duration $initTimeout = this.getInitTimeout();
            result = result * 59 + ($initTimeout == null ? 43 : ((Object)$initTimeout).hashCode());
            WorkloadApiClient $workloadApiClient = this.getWorkloadApiClient();
            result = result * 59 + ($workloadApiClient == null ? 43 : $workloadApiClient.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DefaultJwtSource.JwtSourceOptions(spiffeSocketPath=" + this.getSpiffeSocketPath() + ", initTimeout=" + this.getInitTimeout() + ", workloadApiClient=" + this.getWorkloadApiClient() + ")";
        }

        @Generated
        public static class JwtSourceOptionsBuilder {
            @Generated
            private String spiffeSocketPath;
            @Generated
            private WorkloadApiClient workloadApiClient;
            @Generated
            private Duration initTimeout;

            @Generated
            JwtSourceOptionsBuilder() {
            }

            @Generated
            public JwtSourceOptionsBuilder spiffeSocketPath(String spiffeSocketPath) {
                this.spiffeSocketPath = spiffeSocketPath;
                return this;
            }

            @Generated
            public JwtSourceOptionsBuilder workloadApiClient(WorkloadApiClient workloadApiClient) {
                this.workloadApiClient = workloadApiClient;
                return this;
            }

            @Generated
            public JwtSourceOptionsBuilder initTimeout(Duration initTimeout) {
                this.initTimeout = initTimeout;
                return this;
            }

            @Generated
            public JwtSourceOptions build() {
                return new JwtSourceOptions(this.spiffeSocketPath, this.workloadApiClient, this.initTimeout);
            }

            @Generated
            public String toString() {
                return "DefaultJwtSource.JwtSourceOptions.JwtSourceOptionsBuilder(spiffeSocketPath=" + this.spiffeSocketPath + ", workloadApiClient=" + this.workloadApiClient + ", initTimeout=" + this.initTimeout + ")";
            }
        }
    }
}

