/*
 * Decompiled with CFR 0.152.
 */
package io.spiffe.workloadapi;

import io.grpc.Context;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import io.spiffe.bundle.jwtbundle.JwtBundleSet;
import io.spiffe.exception.JwtBundleException;
import io.spiffe.exception.X509ContextException;
import io.spiffe.workloadapi.GrpcConversionUtils;
import io.spiffe.workloadapi.Watcher;
import io.spiffe.workloadapi.X509Context;
import io.spiffe.workloadapi.grpc.SpiffeWorkloadAPIGrpc;
import io.spiffe.workloadapi.grpc.Workload;
import io.spiffe.workloadapi.retry.RetryHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;

final class StreamObservers {
    @Generated
    private static final Logger log = Logger.getLogger(StreamObservers.class.getName());
    private static final String INVALID_ARGUMENT = "INVALID_ARGUMENT";

    private StreamObservers() {
    }

    static StreamObserver<Workload.X509SVIDResponse> getX509ContextStreamObserver(final Watcher<X509Context> watcher, final RetryHandler retryHandler, final Context.CancellableContext cancellableContext, final SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIStub workloadApiAsyncStub) {
        return new StreamObserver<Workload.X509SVIDResponse>(){

            public void onNext(Workload.X509SVIDResponse value) {
                try {
                    X509Context x509Context = GrpcConversionUtils.toX509Context(value);
                    watcher.onUpdate(x509Context);
                    retryHandler.reset();
                }
                catch (X509ContextException e) {
                    watcher.onError(new X509ContextException("Error processing X.509 Context update", e));
                }
            }

            public void onError(Throwable t) {
                log.log(Level.SEVERE, "X.509 context observer error", t);
                this.handleWatchX509ContextError(t);
            }

            private void handleWatchX509ContextError(Throwable t) {
                if (StreamObservers.isErrorNotRetryable(t)) {
                    watcher.onError(new X509ContextException("Canceling X.509 Context watch", t));
                } else {
                    this.handleX509ContextRetry(t);
                }
            }

            private void handleX509ContextRetry(Throwable t) {
                if (retryHandler.shouldRetry()) {
                    log.log(Level.INFO, "Retrying connecting to Workload API to register X.509 context watcher");
                    retryHandler.scheduleRetry(() -> cancellableContext.run(() -> workloadApiAsyncStub.fetchX509SVID(StreamObservers.newX509SvidRequest(), this)));
                } else {
                    watcher.onError(new X509ContextException("Canceling X.509 Context watch", t));
                }
            }

            public void onCompleted() {
                cancellableContext.close();
                log.info("Workload API stream is completed");
            }
        };
    }

    static StreamObserver<Workload.JWTBundlesResponse> getJwtBundleStreamObserver(final Watcher<JwtBundleSet> watcher, final RetryHandler retryHandler, final Context.CancellableContext cancellableContext, final SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIStub workloadApiAsyncStub) {
        return new StreamObserver<Workload.JWTBundlesResponse>(){

            public void onNext(Workload.JWTBundlesResponse value) {
                try {
                    JwtBundleSet jwtBundleSet = GrpcConversionUtils.toBundleSet(value);
                    watcher.onUpdate(jwtBundleSet);
                    retryHandler.reset();
                }
                catch (JwtBundleException e) {
                    watcher.onError(new JwtBundleException("Error processing JWT bundles update", e));
                }
            }

            public void onError(Throwable t) {
                log.log(Level.SEVERE, "JWT observer error", t);
                this.handleWatchJwtBundleError(t);
            }

            private void handleWatchJwtBundleError(Throwable t) {
                if (StreamObservers.isErrorNotRetryable(t)) {
                    watcher.onError(new JwtBundleException("Canceling JWT Bundles watch", t));
                } else {
                    this.handleJwtBundleRetry(t);
                }
            }

            private void handleJwtBundleRetry(Throwable t) {
                if (retryHandler.shouldRetry()) {
                    log.log(Level.INFO, "Retrying connecting to Workload API to register JWT Bundles watcher");
                    retryHandler.scheduleRetry(() -> cancellableContext.run(() -> workloadApiAsyncStub.fetchJWTBundles(StreamObservers.newJwtBundlesRequest(), this)));
                } else {
                    watcher.onError(new JwtBundleException("Canceling JWT Bundles watch", t));
                }
            }

            public void onCompleted() {
                cancellableContext.close();
                log.info("Workload API stream is completed");
            }
        };
    }

    private static boolean isErrorNotRetryable(Throwable t) {
        return INVALID_ARGUMENT.equals(Status.fromThrowable((Throwable)t).getCode().name());
    }

    private static Workload.X509SVIDRequest newX509SvidRequest() {
        return Workload.X509SVIDRequest.newBuilder().build();
    }

    private static Workload.JWTBundlesRequest newJwtBundlesRequest() {
        return Workload.JWTBundlesRequest.newBuilder().build();
    }
}

