/*
 * Decompiled with CFR 0.152.
 */
package io.spiffe.bundle.x509bundle;

import io.spiffe.bundle.BundleSource;
import io.spiffe.exception.BundleNotFoundException;
import io.spiffe.exception.X509BundleException;
import io.spiffe.internal.CertificateUtils;
import io.spiffe.spiffeid.TrustDomain;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import lombok.NonNull;

public final class X509Bundle
implements BundleSource<X509Bundle> {
    private final TrustDomain trustDomain;
    private final Set<X509Certificate> x509Authorities;

    public X509Bundle(@NonNull TrustDomain trustDomain) {
        if (trustDomain == null) {
            throw new NullPointerException("trustDomain is marked non-null but is null");
        }
        this.trustDomain = trustDomain;
        this.x509Authorities = ConcurrentHashMap.newKeySet();
    }

    public X509Bundle(@NonNull TrustDomain trustDomain, @NonNull Set<X509Certificate> x509Authorities) {
        if (trustDomain == null) {
            throw new NullPointerException("trustDomain is marked non-null but is null");
        }
        if (x509Authorities == null) {
            throw new NullPointerException("x509Authorities is marked non-null but is null");
        }
        this.trustDomain = trustDomain;
        this.x509Authorities = ConcurrentHashMap.newKeySet();
        this.x509Authorities.addAll(x509Authorities);
    }

    public static X509Bundle load(@NonNull TrustDomain trustDomain, @NonNull Path bundlePath) throws X509BundleException {
        byte[] bundleBytes;
        if (trustDomain == null) {
            throw new NullPointerException("trustDomain is marked non-null but is null");
        }
        if (bundlePath == null) {
            throw new NullPointerException("bundlePath is marked non-null but is null");
        }
        try {
            bundleBytes = Files.readAllBytes(bundlePath);
        }
        catch (IOException e) {
            throw new X509BundleException("Unable to load X.509 bundle file", e);
        }
        List<X509Certificate> x509Certificates = X509Bundle.generateX509Certificates(bundleBytes);
        HashSet<X509Certificate> x509CertificateSet = new HashSet<X509Certificate>(x509Certificates);
        return new X509Bundle(trustDomain, x509CertificateSet);
    }

    public static X509Bundle parse(@NonNull TrustDomain trustDomain, @NonNull byte[] bundleBytes) throws X509BundleException {
        if (trustDomain == null) {
            throw new NullPointerException("trustDomain is marked non-null but is null");
        }
        if (bundleBytes == null) {
            throw new NullPointerException("bundleBytes is marked non-null but is null");
        }
        List<X509Certificate> x509Certificates = X509Bundle.generateX509Certificates(bundleBytes);
        HashSet<X509Certificate> x509CertificateSet = new HashSet<X509Certificate>(x509Certificates);
        return new X509Bundle(trustDomain, x509CertificateSet);
    }

    @Override
    public X509Bundle getBundleForTrustDomain(@NonNull TrustDomain trustDomain) throws BundleNotFoundException {
        if (trustDomain == null) {
            throw new NullPointerException("trustDomain is marked non-null but is null");
        }
        if (this.trustDomain.equals(trustDomain)) {
            return this;
        }
        throw new BundleNotFoundException(String.format("No X.509 bundle found for trust domain %s", trustDomain));
    }

    public Set<X509Certificate> getX509Authorities() {
        return Collections.unmodifiableSet(this.x509Authorities);
    }

    public boolean hasX509Authority(@NonNull X509Certificate x509Authority) {
        if (x509Authority == null) {
            throw new NullPointerException("x509Authority is marked non-null but is null");
        }
        return this.x509Authorities.contains(x509Authority);
    }

    public void addX509Authority(@NonNull X509Certificate x509Authority) {
        if (x509Authority == null) {
            throw new NullPointerException("x509Authority is marked non-null but is null");
        }
        this.x509Authorities.add(x509Authority);
    }

    public void removeX509Authority(@NonNull X509Certificate x509Authority) {
        if (x509Authority == null) {
            throw new NullPointerException("x509Authority is marked non-null but is null");
        }
        this.x509Authorities.remove(x509Authority);
    }

    private static List<X509Certificate> generateX509Certificates(byte[] bundleBytes) throws X509BundleException {
        List<X509Certificate> x509Certificates;
        try {
            x509Certificates = CertificateUtils.generateCertificates(bundleBytes);
        }
        catch (CertificateParsingException e) {
            throw new X509BundleException("Bundle certificates could not be parsed from bundle path", e);
        }
        return x509Certificates;
    }

    @Generated
    public TrustDomain getTrustDomain() {
        return this.trustDomain;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof X509Bundle)) {
            return false;
        }
        X509Bundle other = (X509Bundle)o;
        TrustDomain this$trustDomain = this.getTrustDomain();
        TrustDomain other$trustDomain = other.getTrustDomain();
        if (this$trustDomain == null ? other$trustDomain != null : !((Object)this$trustDomain).equals(other$trustDomain)) {
            return false;
        }
        Set<X509Certificate> this$x509Authorities = this.getX509Authorities();
        Set<X509Certificate> other$x509Authorities = other.getX509Authorities();
        return !(this$x509Authorities == null ? other$x509Authorities != null : !((Object)this$x509Authorities).equals(other$x509Authorities));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TrustDomain $trustDomain = this.getTrustDomain();
        result = result * 59 + ($trustDomain == null ? 43 : ((Object)$trustDomain).hashCode());
        Set<X509Certificate> $x509Authorities = this.getX509Authorities();
        result = result * 59 + ($x509Authorities == null ? 43 : ((Object)$x509Authorities).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "X509Bundle(trustDomain=" + this.getTrustDomain() + ", x509Authorities=" + this.getX509Authorities() + ")";
    }
}

