/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.cats.agent;

import com.netflix.spinnaker.cats.agent.Agent;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.AgentExecution;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.CacheIntrospectionStore;
import com.netflix.spinnaker.cats.cache.DefaultAgentIntrospection;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.cats.provider.ProviderRegistry;
import com.netflix.spinnaker.kork.annotations.Beta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public interface CachingAgent
extends Agent {
    public Collection<AgentDataType> getProvidedDataTypes();

    public CacheResult loadData(ProviderCache var1);

    default public Optional<Map<String, String>> getCacheKeyPatterns() {
        return Optional.empty();
    }

    @Override
    default public AgentExecution getAgentExecution(ProviderRegistry providerRegistry) {
        return new CacheExecution(providerRegistry);
    }

    public static class CacheExecution
    implements AgentExecution {
        private final Logger log = LoggerFactory.getLogger(CacheExecution.class);
        private final ProviderRegistry providerRegistry;

        public CacheExecution(ProviderRegistry providerRegistry) {
            this.providerRegistry = providerRegistry;
        }

        @Override
        public void executeAgent(Agent agent) {
            DefaultAgentIntrospection introspection = new DefaultAgentIntrospection(agent);
            CacheResult result = this.executeAgentWithoutStore(agent);
            introspection.finish(result);
            CacheIntrospectionStore.getStore().recordAgent(introspection);
            this.storeAgentResult(agent, result);
        }

        public CacheResult executeAgentWithoutStore(Agent agent) {
            CachingAgent cachingAgent = (CachingAgent)agent;
            ProviderCache cache = this.providerRegistry.getProviderCache(cachingAgent.getProviderName());
            return cachingAgent.loadData(cache);
        }

        public void storeAgentResult(Agent agent, CacheResult result) {
            CachingAgent cachingAgent = (CachingAgent)agent;
            ProviderCache cache = this.providerRegistry.getProviderCache(cachingAgent.getProviderName());
            Collection<AgentDataType> providedTypes = cachingAgent.getProvidedDataTypes();
            HashSet<String> authoritative = new HashSet<String>(providedTypes.size());
            for (AgentDataType type : providedTypes) {
                if (type.getAuthority() != AgentDataType.Authority.AUTHORITATIVE) continue;
                authoritative.add(type.getTypeName());
            }
            Optional<Map<String, String>> cacheKeyPatterns = cachingAgent.getCacheKeyPatterns();
            if (cacheKeyPatterns.isPresent()) {
                for (String type : authoritative) {
                    String cacheKeyPatternForType = cacheKeyPatterns.get().get(type);
                    if (cacheKeyPatternForType == null) continue;
                    try {
                        Set cachedIdentifiersForType = result.getCacheResults().get(type).stream().map(CacheData::getId).collect(Collectors.toSet());
                        Collection evictableIdentifiers = cache.filterIdentifiers(type, cacheKeyPatternForType).stream().filter(i -> !cachedIdentifiersForType.contains(i)).collect(Collectors.toSet());
                        if (evictableIdentifiers.isEmpty()) continue;
                        Collection evictionsForType = result.getEvictions().computeIfAbsent(type, evictableKeys -> new ArrayList());
                        evictionsForType.addAll(evictableIdentifiers);
                        this.log.debug("Evicting stale identifiers: {}", (Object)evictableIdentifiers);
                    }
                    catch (Exception e) {
                        this.log.error("Failed to check for stale identifiers (type: {}, pattern: {}, agent: {})", new Object[]{type, cacheKeyPatternForType, agent, e});
                    }
                }
            }
            if (result.isPartialResult()) {
                cache.addCacheResult(agent.getAgentType(), authoritative, result);
            } else {
                cache.putCacheResult(agent.getAgentType(), authoritative, result);
            }
        }
    }
}

