/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.cats.cache;

import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.kork.annotations.Beta;
import java.time.Clock;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@Beta
public class DefaultCacheData
implements CacheData {
    private final String id;
    private final int ttlSeconds;
    private final Map<String, Object> attributes;
    private final Map<String, Collection<String>> relationships;

    public DefaultCacheData(String id, Map<String, Object> attributes, Map<String, Collection<String>> relationships) {
        this(id, -1, attributes, relationships);
    }

    public DefaultCacheData(String id, int ttlSeconds, Map<String, Object> attributes, Map<String, Collection<String>> relationships) {
        this(id, ttlSeconds, attributes, relationships, Clock.systemDefaultZone());
    }

    public DefaultCacheData(String id, int ttlSeconds, Map<String, Object> attributes, Map<String, Collection<String>> relationships, Clock clock) {
        attributes = attributes == null ? new HashMap<String, Object>() : new HashMap<String, Object>(attributes);
        this.id = id;
        this.attributes = attributes;
        this.relationships = relationships;
        if (ttlSeconds > 0) {
            Long cacheExpiry = clock.millis() + (long)(ttlSeconds * 1000);
            this.attributes.put("cacheExpiry", cacheExpiry);
        }
        if (ttlSeconds < 0 && attributes.containsKey("cacheExpiry")) {
            ttlSeconds = (int)(clock.millis() - (Long)attributes.get("cacheExpiry")) * -1 / 1000;
        }
        this.ttlSeconds = ttlSeconds;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getTtlSeconds() {
        return this.ttlSeconds;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public Map<String, Collection<String>> getRelationships() {
        return this.relationships;
    }
}

