/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.cats.cache;

import com.netflix.spinnaker.cats.agent.Agent;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.cache.AgentIntrospection;
import com.netflix.spinnaker.kork.annotations.Beta;
import java.text.SimpleDateFormat;
import java.util.Map;
import lombok.Generated;

@Beta
public class DefaultAgentIntrospection
implements AgentIntrospection {
    private String id;
    private String provider;
    private int totalAdditions;
    private int totalEvictions;
    private Map<String, Object> details;
    private Throwable lastError;
    private Long lastExecutionStartMs;
    private Long lastExecutionDurationMs;

    public DefaultAgentIntrospection(Agent agent) {
        this.lastExecutionStartMs = System.currentTimeMillis();
        this.id = agent.getAgentType();
        this.provider = agent.getProviderName();
    }

    @Override
    public void finishWithError(Throwable error, CacheResult result) {
        this.lastError = error;
        this.finish(result);
    }

    @Override
    public void finish(CacheResult result) {
        this.lastExecutionDurationMs = System.currentTimeMillis() - this.lastExecutionStartMs;
        this.details = result.getIntrospectionDetails();
        this.totalAdditions = result.getCacheResults().values().stream().reduce(0, (a, b) -> a + b.size(), (a, b) -> a + b);
        this.totalEvictions = result.getEvictions().values().stream().reduce(0, (a, b) -> a + b.size(), (a, b) -> a + b);
    }

    @Override
    public String getLastExecutionStartDate() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(this.lastExecutionStartMs);
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getProvider() {
        return this.provider;
    }

    @Override
    @Generated
    public int getTotalAdditions() {
        return this.totalAdditions;
    }

    @Override
    @Generated
    public int getTotalEvictions() {
        return this.totalEvictions;
    }

    @Generated
    public Map<String, Object> getDetails() {
        return this.details;
    }

    @Override
    @Generated
    public Throwable getLastError() {
        return this.lastError;
    }

    @Override
    @Generated
    public Long getLastExecutionStartMs() {
        return this.lastExecutionStartMs;
    }

    @Override
    @Generated
    public Long getLastExecutionDurationMs() {
        return this.lastExecutionDurationMs;
    }

    @Generated
    public DefaultAgentIntrospection setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public DefaultAgentIntrospection setProvider(String provider) {
        this.provider = provider;
        return this;
    }

    @Generated
    public DefaultAgentIntrospection setTotalAdditions(int totalAdditions) {
        this.totalAdditions = totalAdditions;
        return this;
    }

    @Generated
    public DefaultAgentIntrospection setTotalEvictions(int totalEvictions) {
        this.totalEvictions = totalEvictions;
        return this;
    }

    @Generated
    public DefaultAgentIntrospection setDetails(Map<String, Object> details) {
        this.details = details;
        return this;
    }

    @Generated
    public DefaultAgentIntrospection setLastError(Throwable lastError) {
        this.lastError = lastError;
        return this;
    }

    @Generated
    public DefaultAgentIntrospection setLastExecutionStartMs(Long lastExecutionStartMs) {
        this.lastExecutionStartMs = lastExecutionStartMs;
        return this;
    }

    @Generated
    public DefaultAgentIntrospection setLastExecutionDurationMs(Long lastExecutionDurationMs) {
        this.lastExecutionDurationMs = lastExecutionDurationMs;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultAgentIntrospection)) {
            return false;
        }
        DefaultAgentIntrospection other = (DefaultAgentIntrospection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalAdditions() != other.getTotalAdditions()) {
            return false;
        }
        if (this.getTotalEvictions() != other.getTotalEvictions()) {
            return false;
        }
        Long this$lastExecutionStartMs = this.getLastExecutionStartMs();
        Long other$lastExecutionStartMs = other.getLastExecutionStartMs();
        if (this$lastExecutionStartMs == null ? other$lastExecutionStartMs != null : !((Object)this$lastExecutionStartMs).equals(other$lastExecutionStartMs)) {
            return false;
        }
        Long this$lastExecutionDurationMs = this.getLastExecutionDurationMs();
        Long other$lastExecutionDurationMs = other.getLastExecutionDurationMs();
        if (this$lastExecutionDurationMs == null ? other$lastExecutionDurationMs != null : !((Object)this$lastExecutionDurationMs).equals(other$lastExecutionDurationMs)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$provider = this.getProvider();
        String other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
            return false;
        }
        Map<String, Object> this$details = this.getDetails();
        Map<String, Object> other$details = other.getDetails();
        if (this$details == null ? other$details != null : !((Object)this$details).equals(other$details)) {
            return false;
        }
        Throwable this$lastError = this.getLastError();
        Throwable other$lastError = other.getLastError();
        return !(this$lastError == null ? other$lastError != null : !this$lastError.equals(other$lastError));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultAgentIntrospection;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTotalAdditions();
        result = result * 59 + this.getTotalEvictions();
        Long $lastExecutionStartMs = this.getLastExecutionStartMs();
        result = result * 59 + ($lastExecutionStartMs == null ? 43 : ((Object)$lastExecutionStartMs).hashCode());
        Long $lastExecutionDurationMs = this.getLastExecutionDurationMs();
        result = result * 59 + ($lastExecutionDurationMs == null ? 43 : ((Object)$lastExecutionDurationMs).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        Map<String, Object> $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        Throwable $lastError = this.getLastError();
        result = result * 59 + ($lastError == null ? 43 : $lastError.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DefaultAgentIntrospection(id=" + this.getId() + ", provider=" + this.getProvider() + ", totalAdditions=" + this.getTotalAdditions() + ", totalEvictions=" + this.getTotalEvictions() + ", details=" + String.valueOf(this.getDetails()) + ", lastError=" + String.valueOf(this.getLastError()) + ", lastExecutionStartMs=" + this.getLastExecutionStartMs() + ", lastExecutionDurationMs=" + this.getLastExecutionDurationMs() + ")";
    }

    @Generated
    public DefaultAgentIntrospection() {
    }
}

