/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cache;

import com.netflix.spinnaker.cats.agent.Agent;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.provider.Provider;
import com.netflix.spinnaker.clouddriver.cache.KeyParser;
import com.netflix.spinnaker.kork.annotations.Beta;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

@Beta
public interface SearchableProvider
extends Provider {
    public Set<String> getDefaultCaches();

    public Map<String, String> getUrlMappingTemplates();

    public Map<SearchableResource, SearchResultHydrator> getSearchResultHydrators();

    public Map<String, String> parseKey(String var1);

    default public Optional<KeyParser> getKeyParser() {
        return Optional.empty();
    }

    default public String buildSearchTerm(String type, String queryTerm) {
        String prefix = this.getKeyParser().map(KeyParser::getCloudProvider).orElse("*");
        return prefix + ":" + type + ":*" + queryTerm + "*";
    }

    default public boolean supportsSearch(String type, Map<String, String> filters) {
        boolean filterMatch = filters == null || !filters.containsKey("cloudProvider") ? true : this.getKeyParser().map(kp -> kp.canParseType(type) != false && kp.getCloudProvider().equals(filters.get("cloudProvider"))).orElse(true);
        return filterMatch && SearchableProvider.hasAgentForType(type, this.getAgents());
    }

    public static boolean hasAgentForType(String type, Collection<Agent> agents) {
        return agents.stream().filter(CachingAgent.class::isInstance).map(CachingAgent.class::cast).anyMatch(ca -> ca.getProvidedDataTypes().stream().anyMatch(pdt -> pdt.getTypeName().equals(type)));
    }

    public static class SearchableResource {
        String resourceType;
        String platform;

        @Generated
        public String getResourceType() {
            return this.resourceType;
        }

        @Generated
        public String getPlatform() {
            return this.platform;
        }

        @Generated
        public SearchableResource setResourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Generated
        public SearchableResource setPlatform(String platform) {
            this.platform = platform;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SearchableResource)) {
                return false;
            }
            SearchableResource other = (SearchableResource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$resourceType = this.getResourceType();
            String other$resourceType = other.getResourceType();
            if (this$resourceType == null ? other$resourceType != null : !this$resourceType.equals(other$resourceType)) {
                return false;
            }
            String this$platform = this.getPlatform();
            String other$platform = other.getPlatform();
            return !(this$platform == null ? other$platform != null : !this$platform.equals(other$platform));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SearchableResource;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $resourceType = this.getResourceType();
            result = result * 59 + ($resourceType == null ? 43 : $resourceType.hashCode());
            String $platform = this.getPlatform();
            result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SearchableProvider.SearchableResource(resourceType=" + this.getResourceType() + ", platform=" + this.getPlatform() + ")";
        }

        @Generated
        public SearchableResource(String resourceType, String platform) {
            this.resourceType = resourceType;
            this.platform = platform;
        }

        @Generated
        public SearchableResource() {
        }
    }

    public static interface SearchResultHydrator {
        public Map<String, String> hydrateResult(Cache var1, Map<String, String> var2, String var3);
    }
}

