/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.appengine.deploy.ops;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.appengine.AppengineJobExecutor;
import com.netflix.spinnaker.clouddriver.appengine.artifacts.GcsStorageService;
import com.netflix.spinnaker.clouddriver.appengine.artifacts.config.StorageConfigurationProperties;
import com.netflix.spinnaker.clouddriver.appengine.config.AppengineConfigurationProperties;
import com.netflix.spinnaker.clouddriver.appengine.deploy.AppengineMutexRepository;
import com.netflix.spinnaker.clouddriver.appengine.deploy.AppengineServerGroupNameResolver;
import com.netflix.spinnaker.clouddriver.appengine.deploy.description.DeployAppengineDescription;
import com.netflix.spinnaker.clouddriver.appengine.deploy.exception.AppengineOperationException;
import com.netflix.spinnaker.clouddriver.appengine.gcsClient.AppengineGcsRepositoryClient;
import com.netflix.spinnaker.clouddriver.artifacts.ArtifactDownloader;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.deploy.DeploymentResult;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;

public class DeployAppengineAtomicOperation
implements AtomicOperation<DeploymentResult>,
GroovyObject {
    private static final String BASE_PHASE = "DEPLOY";
    @Autowired
    private Registry registry;
    @Autowired
    private AppengineJobExecutor jobExecutor;
    @Autowired(required=false)
    private StorageConfigurationProperties storageConfiguration;
    @Autowired(required=false)
    private GcsStorageService.Factory storageServiceFactory;
    @Autowired
    private ArtifactDownloader artifactDownloader;
    private DeployAppengineDescription description;
    private boolean usesGcs;
    private boolean containerDeployment;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DeployAppengineAtomicOperation(DeployAppengineDescription description) {
        DeployAppengineDescription deployAppengineDescription;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = deployAppengineDescription = description;
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "artifact", 4, description)) != false) {
            CallSite callSite = IndyInterface.bootstrap("getProperty", "type", 0, IndyInterface.bootstrap("getProperty", "artifact", 4, description));
            if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"gcs/object")) {
                boolean bl;
                CallSite ref = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "reference", 0, IndyInterface.bootstrap("getProperty", "artifact", 4, description)));
                if (IndyInterface.bootstrap("cast", "()", 0, ref) == false) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, AppengineOperationException.class, "Missing artifact reference for GCS deploy"));
                }
                CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "startsWith", 0, ref, "gs://")) != false ? ref : new GStringImpl(new Object[]{ref}, new String[]{"gs://", ""});
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite2, DeployAppengineAtomicOperation.class, (GroovyObject)description, (String)"repositoryUrl");
                this.usesGcs = bl = true;
                return;
            } else {
                if (!ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"docker/image")) throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, AppengineOperationException.class, "Unhandled artifact type in description"));
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "artifact", 4, description))) == false) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, AppengineOperationException.class, "Missing artifact name for Flex Custom deploy"));
                }
                CallSite callSite3 = IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "artifact", 4, description));
                this.containerDeployment = DefaultTypeTransformation.booleanUnbox((Object)callSite3);
            }
            return;
        } else {
            boolean bl;
            CallSite callSite = IndyInterface.bootstrap("invoke", "trim", 1, IndyInterface.bootstrap("getProperty", "containerImageUrl", 4, description));
            this.containerDeployment = DefaultTypeTransformation.booleanUnbox((Object)callSite);
            this.usesGcs = bl = !this.containerDeployment && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "startsWith", 0, IndyInterface.bootstrap("getProperty", "repositoryUrl", 4, description), "gs://"));
        }
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    public DeploymentResult operate(List priorOutputs) {
        CallSite baseDir = IndyInterface.bootstrap("getProperty", "localRepositoryDirectory", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description));
        CallSite directoryId = null;
        directoryId = this.containerDeployment ? IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "containerImageUrl", 4, this.description)) : IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "repositoryUrl", 4, this.description));
        Reference directoryPath = new Reference((Object)IndyInterface.bootstrap("invoke", "getFullDirectoryPath", 0, DeployAppengineAtomicOperation.class, baseDir, directoryId));
        Reference serviceAccount = new Reference((Object)IndyInterface.bootstrap("getProperty", "serviceAccountEmail", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)));
        Reference region = new Reference((Object)IndyInterface.bootstrap("getProperty", "region", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)));
        IndyInterface.bootstrap("invoke", "increment", 0, IndyInterface.bootstrap("invoke", "counter", 0, this.registry, IndyInterface.bootstrap("invoke", "createId", 0, this.registry, "appengine.deployStart", "account", serviceAccount.get(), "region", region.get())));
        public final class _operate_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference directoryPath;
            private /* synthetic */ Reference serviceAccount;
            private /* synthetic */ Reference region;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure1(Object _outerInstance, Object _thisObject, Reference directoryPath, Reference serviceAccount, Reference region) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.directoryPath = reference3 = directoryPath;
                this.serviceAccount = reference2 = serviceAccount;
                this.region = reference = region;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object doCall(Object it) {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), "Initializing creation of version...");
                CallSite newVersionName = null;
                CallSite deployPath = null;
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "containerDeployment", 12, this)) != false) {
                    IndyInterface.bootstrap("invoke", "createEmptyDirectory", 2, this, this.directoryPath.get());
                    deployPath = IndyInterface.bootstrap("cast", "()", 0, this.directoryPath.get());
                } else {
                    CallSite startTime = IndyInterface.bootstrap("invoke", "monotonicTime", 0, IndyInterface.bootstrap("invoke", "clock", 0, IndyInterface.bootstrap("getProperty", "registry", 12, this)));
                    String success = "false";
                    try {
                        deployPath = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "cloneOrUpdateLocalRepository", 2, this, this.directoryPath.get(), true));
                        success = "true";
                    }
                    catch (Throwable throwable) {
                        CallSite duration = IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "monotonicTime", 0, IndyInterface.bootstrap("invoke", "clock", 0, IndyInterface.bootstrap("getProperty", "registry", 12, this))), startTime);
                        IndyInterface.bootstrap("invoke", "record", 0, IndyInterface.bootstrap("invoke", "timer", 0, IndyInterface.bootstrap("getProperty", "registry", 12, this), IndyInterface.bootstrap("invoke", "createId", 0, IndyInterface.bootstrap("getProperty", "registry", 12, this), "appengine.repositoryDownload", "account", this.serviceAccount.get(), "repositoryType", IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "usesGcs", 12, this)) != false ? "gcs" : "git", "success", success)), duration, IndyInterface.bootstrap("getProperty", "NANOSECONDS", 0, TimeUnit.class));
                        throw throwable;
                    }
                    CallSite duration = IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "monotonicTime", 0, IndyInterface.bootstrap("invoke", "clock", 0, IndyInterface.bootstrap("getProperty", "registry", 12, this))), startTime);
                    IndyInterface.bootstrap("invoke", "record", 0, IndyInterface.bootstrap("invoke", "timer", 0, IndyInterface.bootstrap("getProperty", "registry", 12, this), IndyInterface.bootstrap("invoke", "createId", 0, IndyInterface.bootstrap("getProperty", "registry", 12, this), "appengine.repositoryDownload", "account", this.serviceAccount.get(), "repositoryType", IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "usesGcs", 12, this)) != false ? "gcs" : "git", "success", success)), duration, IndyInterface.bootstrap("getProperty", "NANOSECONDS", 0, TimeUnit.class));
                }
                CallSite startTime = IndyInterface.bootstrap("invoke", "monotonicTime", 0, IndyInterface.bootstrap("invoke", "clock", 0, IndyInterface.bootstrap("getProperty", "registry", 12, this)));
                String success = "false";
                try {
                    newVersionName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "deploy", 2, this, deployPath));
                    success = "true";
                }
                finally {
                    CallSite duration = IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "monotonicTime", 0, IndyInterface.bootstrap("invoke", "clock", 0, IndyInterface.bootstrap("getProperty", "registry", 12, this))), startTime);
                    IndyInterface.bootstrap("invoke", "record", 0, IndyInterface.bootstrap("invoke", "timer", 0, IndyInterface.bootstrap("getProperty", "registry", 12, this), IndyInterface.bootstrap("invoke", "createId", 0, IndyInterface.bootstrap("getProperty", "registry", 12, this), "appengine.deploy", "success", success, "account", this.serviceAccount.get(), "region", this.region.get())), duration, IndyInterface.bootstrap("getProperty", "NANOSECONDS", 0, TimeUnit.class));
                }
                CallSite result = IndyInterface.bootstrap("init", "<init>", 0, DeploymentResult.class);
                CallSite callSite = IndyInterface.bootstrap("invoke", "asList", 0, Arrays.class, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{this.region.get(), newVersionName}, new String[]{"", ":", ""})));
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)result, (String)"serverGroupNames");
                CallSite callSite2 = newVersionName;
                IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("getProperty", "serverGroupNameByRegion", 0, result), this.region.get(), callSite2);
                return result;
            }

            @Generated
            public Object getDirectoryPath() {
                return this.directoryPath.get();
            }

            @Generated
            public Object getServiceAccount() {
                return this.serviceAccount.get();
            }

            @Generated
            public Object getRegion() {
                return this.region.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "atomicWrapper", 0, AppengineMutexRepository.class, directoryPath.get(), new _operate_closure1(this, this, directoryPath, serviceAccount, region)));
    }

    public void createEmptyDirectory(String path) {
        CallSite directory = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, path));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, directory)) != false) {
            IndyInterface.bootstrap("invoke", "deleteDir", 0, directory);
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "mkdirs", 0, directory)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, AppengineOperationException.class, new GStringImpl(new Object[]{path}, new String[]{"Failed to create directory: ", ""})));
        }
    }

    public String cloneOrUpdateLocalRepository(String directoryPath, Integer retryCount) {
        CallSite repositoryUrl = IndyInterface.bootstrap("getProperty", "repositoryUrl", 4, this.description);
        CallSite directory = IndyInterface.bootstrap("init", "<init>", 0, File.class, directoryPath);
        CallSite branch = IndyInterface.bootstrap("getProperty", "branch", 4, this.description);
        Object branchLogName = branch;
        CallSite repositoryClient = null;
        if (this.usesGcs) {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.storageConfiguration, null)) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, "GCS has been disabled. To enable it, configure storage.gcs.enabled=false and restart clouddriver."));
            }
            CallSite applicationDirectoryRoot = IndyInterface.bootstrap("getProperty", "applicationDirectoryRoot", 4, this.description);
            Object credentialPath = "";
            Object storageAccountName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "storageAccountName", 4, this.description));
            if (ScriptBytecodeAdapter.compareNotEqual((Object)storageAccountName, null) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, storageAccountName)) == false) {
                credentialPath = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "jsonPath", 0, IndyInterface.bootstrap("invoke", "getAccount", 0, this.storageConfiguration, IndyInterface.bootstrap("getProperty", "storageAccountName", 4, this.description))));
            } else {
                storageAccountName = "ApplicationDefaultCredentials";
            }
            CallSite storage = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "newForCredentials", 0, this.storageServiceFactory, credentialPath));
            repositoryClient = IndyInterface.bootstrap("init", "<init>", 0, AppengineGcsRepositoryClient.class, repositoryUrl, directoryPath, applicationDirectoryRoot, storage, this.jobExecutor);
            branchLogName = "(current)";
        } else {
            repositoryClient = IndyInterface.bootstrap("invoke", "buildRepositoryClient", 0, IndyInterface.bootstrap("getProperty", "gitCredentials", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), repositoryUrl, directoryPath, IndyInterface.bootstrap("getProperty", "gitCredentialType", 4, this.description));
        }
        try {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, directory)) == false) {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{repositoryUrl}, new String[]{"Grabbing repository ", " into local directory..."}));
                IndyInterface.bootstrap("invoke", "mkdir", 0, directory);
                IndyInterface.bootstrap("invoke", "initializeLocalDirectory", 0, repositoryClient);
            }
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{repositoryUrl, branchLogName}, new String[]{"Fetching updates from ", " for ", "..."}));
            IndyInterface.bootstrap("invoke", "updateLocalDirectoryWithVersion", 0, repositoryClient, branch);
        }
        catch (Exception e) {
            IndyInterface.bootstrap("invoke", "deleteDir", 0, directory);
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)retryCount, (Object)0)) {
                CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "cloneOrUpdateLocalRepository", 2, this, directoryPath, IndyInterface.bootstrap("invoke", "minus", 0, retryCount, true)));
                return callSite;
            }
            throw (Throwable)e;
        }
        return directoryPath;
    }

    public String deploy(String repositoryPath) {
        Reference repositoryPath2 = new Reference((Object)repositoryPath);
        CallSite project = IndyInterface.bootstrap("getProperty", "project", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description));
        CallSite accountEmail = IndyInterface.bootstrap("getProperty", "serviceAccountEmail", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description));
        CallSite region = IndyInterface.bootstrap("getProperty", "region", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description));
        Reference applicationDirectoryRoot = new Reference((Object)IndyInterface.bootstrap("getProperty", "applicationDirectoryRoot", 4, this.description));
        CallSite gcloudReleaseTrack = IndyInterface.bootstrap("getProperty", "gcloudReleaseTrack", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description));
        CallSite serverGroupNameResolver = IndyInterface.bootstrap("init", "<init>", 0, AppengineServerGroupNameResolver.class, project, region, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description));
        CallSite versionName = IndyInterface.bootstrap("invoke", "resolveNextServerGroupName", 0, serverGroupNameResolver, IndyInterface.bootstrap("getProperty", "application", 4, this.description), IndyInterface.bootstrap("getProperty", "stack", 4, this.description), IndyInterface.bootstrap("getProperty", "freeFormDetails", 4, this.description), IndyInterface.bootstrap("getProperty", "suppressVersionString", 4, this.description));
        CallSite imageUrl = IndyInterface.bootstrap("getProperty", "containerImageUrl", 4, this.description);
        CallSite configFiles = IndyInterface.bootstrap("getProperty", "configFiles", 4, this.description);
        CallSite writtenFullConfigFilePaths = IndyInterface.bootstrap("invoke", "writeConfigFiles", 0, DeployAppengineAtomicOperation.class, configFiles, (String)repositoryPath2.get(), applicationDirectoryRoot.get());
        public final class _deploy_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference repositoryPath;
            private /* synthetic */ Reference applicationDirectoryRoot;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _deploy_closure2(Object _outerInstance, Object _thisObject, Reference repositoryPath, Reference applicationDirectoryRoot) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.repositoryPath = reference2 = repositoryPath;
                this.applicationDirectoryRoot = reference = applicationDirectoryRoot;
            }

            public Object doCall(Object it) {
                Object object;
                return IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "get", 0, Paths.class, IndyInterface.bootstrap("cast", "()", 0, this.repositoryPath.get()), IndyInterface.bootstrap("cast", "()", 0, object = this.applicationDirectoryRoot.get()) != false ? object : ".", it));
            }

            @Generated
            public String getRepositoryPath() {
                return IndyInterface.bootstrap("cast", "()", 0, this.repositoryPath.get());
            }

            @Generated
            public Object getApplicationDirectoryRoot() {
                return this.applicationDirectoryRoot.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deploy_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite callSite = IndyInterface.bootstrap("invoke", "collect", 1, IndyInterface.bootstrap("getProperty", "configFilepaths", 4, this.description), new _deploy_closure2(this, this, repositoryPath2, applicationDirectoryRoot));
        List repositoryFullConfigFilePaths = (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : ScriptBytecodeAdapter.createList((Object[])new Object[0]), List.class));
        CallSite configArtifactPaths = IndyInterface.bootstrap("invoke", "fetchConfigArtifacts", 2, this, IndyInterface.bootstrap("getProperty", "configArtifacts", 4, this.description), (String)repositoryPath2.get(), applicationDirectoryRoot.get());
        Object deployCommand = ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "gcloudPath", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description))});
        if (ScriptBytecodeAdapter.compareNotEqual((Object)gcloudReleaseTrack, null) && ScriptBytecodeAdapter.compareNotEqual((Object)gcloudReleaseTrack, (Object)IndyInterface.bootstrap("getProperty", "STABLE", 0, AppengineConfigurationProperties.ManagedAccount.GcloudReleaseTrack.class))) {
            IndyInterface.bootstrap("invoke", "leftShift", 0, deployCommand, IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("invoke", "toString", 0, gcloudReleaseTrack)));
        }
        deployCommand = IndyInterface.bootstrap("invoke", "plus", 16, deployCommand, ScriptBytecodeAdapter.despreadList((Object[])new Object[]{ScriptBytecodeAdapter.createList((Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[]{"app", "deploy"}, (Object[])new Object[]{IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, repositoryFullConfigFilePaths, writtenFullConfigFilePaths), configArtifactPaths)}, (int[])new int[]{2}))}, (Object[])new Object[0], (int[])new int[0]));
        IndyInterface.bootstrap("invoke", "leftShift", 0, deployCommand, IndyInterface.bootstrap("invoke", "plus", 0, "--version=", versionName));
        IndyInterface.bootstrap("invoke", "leftShift", 0, deployCommand, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "promote", 4, this.description)) != false ? "--promote" : "--no-promote");
        IndyInterface.bootstrap("invoke", "leftShift", 0, deployCommand, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "stopPreviousVersion", 4, this.description)) != false ? "--stop-previous-version" : "--no-stop-previous-version");
        IndyInterface.bootstrap("invoke", "leftShift", 0, deployCommand, IndyInterface.bootstrap("invoke", "plus", 0, "--project=", project));
        IndyInterface.bootstrap("invoke", "leftShift", 0, deployCommand, IndyInterface.bootstrap("invoke", "plus", 0, "--account=", accountEmail));
        if (this.containerDeployment) {
            IndyInterface.bootstrap("invoke", "leftShift", 0, deployCommand, IndyInterface.bootstrap("invoke", "plus", 0, "--image-url=", imageUrl));
        }
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{versionName}, new String[]{"Deploying version ", "..."}));
        CallSite startTime = IndyInterface.bootstrap("invoke", "monotonicTime", 0, IndyInterface.bootstrap("invoke", "clock", 0, this.registry));
        String success = "false";
        try {
            try {
                IndyInterface.bootstrap("invoke", "runCommand", 0, this.jobExecutor, deployCommand);
                success = "true";
            }
            catch (Exception e) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, AppengineOperationException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "join", 0, deployCommand, " "), IndyInterface.bootstrap("invoke", "getMessage", 0, e)}, new String[]{"Failed to deploy to App Engine with command ", ": ", ""})));
            }
        }
        finally {
            CallSite duration = IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "monotonicTime", 0, IndyInterface.bootstrap("invoke", "clock", 0, this.registry)), startTime);
            CallSite id = IndyInterface.bootstrap("invoke", "createId", 0, this.registry, "appengine.deploy", "account", IndyInterface.bootstrap("getProperty", "serviceAccountEmail", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), "region", IndyInterface.bootstrap("getProperty", "region", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), "success", success);
            IndyInterface.bootstrap("invoke", "record", 0, IndyInterface.bootstrap("invoke", "timer", 0, this.registry, id), duration, IndyInterface.bootstrap("getProperty", "NANOSECONDS", 0, TimeUnit.class));
            IndyInterface.bootstrap("invoke", "deleteFiles", 0, DeployAppengineAtomicOperation.class, writtenFullConfigFilePaths);
        }
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{versionName}, new String[]{"Done deploying version ", "..."}));
        return IndyInterface.bootstrap("cast", "()", 0, versionName);
    }

    /*
     * WARNING - void declaration
     */
    public List<String> fetchConfigArtifacts(List<Artifact> configArtifacts, String repositoryPath, String applicationDirectoryRoot) {
        void var3_3;
        Reference repositoryPath2 = new Reference((Object)repositoryPath);
        Reference applicationDirectoryRoot2 = new Reference((Object)var3_3);
        if (IndyInterface.bootstrap("cast", "()", 0, configArtifacts) == false) {
            return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        }
        public final class _fetchConfigArtifacts_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference repositoryPath;
            private /* synthetic */ Reference applicationDirectoryRoot;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _fetchConfigArtifacts_closure3(Object _outerInstance, Object _thisObject, Reference repositoryPath, Reference applicationDirectoryRoot) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.repositoryPath = reference2 = repositoryPath;
                this.applicationDirectoryRoot = reference = applicationDirectoryRoot;
            }

            public Object doCall(Object artifact) {
                CallSite path = IndyInterface.bootstrap("invoke", "generateRandomRepositoryFilePath", 2, this, IndyInterface.bootstrap("cast", "()", 0, this.repositoryPath.get()), IndyInterface.bootstrap("cast", "()", 0, this.applicationDirectoryRoot.get()));
                try {
                    IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("invoke", "toFile", 0, path), IndyInterface.bootstrap("invoke", "download", 0, IndyInterface.bootstrap("getProperty", "artifactDownloader", 12, this), artifact));
                }
                catch (Exception e) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, AppengineOperationException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getMessage", 0, e)}, new String[]{"Could not download artifact as config file: ", ""})));
                }
                return IndyInterface.bootstrap("invoke", "toString", 0, path);
            }

            @Generated
            public String getRepositoryPath() {
                return IndyInterface.bootstrap("cast", "()", 0, this.repositoryPath.get());
            }

            @Generated
            public String getApplicationDirectoryRoot() {
                return IndyInterface.bootstrap("cast", "()", 0, this.applicationDirectoryRoot.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fetchConfigArtifacts_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, configArtifacts, new _fetchConfigArtifacts_closure3(this, this, repositoryPath2, applicationDirectoryRoot2)));
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> writeConfigFiles(List<String> configFiles, String repositoryPath, String applicationDirectoryRoot) {
        void var2_2;
        Reference repositoryPath2 = new Reference((Object)repositoryPath);
        Reference applicationDirectoryRoot2 = new Reference((Object)var2_2);
        if (IndyInterface.bootstrap("cast", "()", 0, configFiles) == false) {
            return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        }
        public final class _writeConfigFiles_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference repositoryPath;
            private /* synthetic */ Reference applicationDirectoryRoot;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _writeConfigFiles_closure4(Object _outerInstance, Object _thisObject, Reference repositoryPath, Reference applicationDirectoryRoot) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.repositoryPath = reference2 = repositoryPath;
                this.applicationDirectoryRoot = reference = applicationDirectoryRoot;
            }

            public Object doCall(Object configFile) {
                CallSite path = IndyInterface.bootstrap("invoke", "generateRandomRepositoryFilePath", 2, this, IndyInterface.bootstrap("cast", "()", 0, this.repositoryPath.get()), IndyInterface.bootstrap("cast", "()", 0, this.applicationDirectoryRoot.get()));
                try {
                    IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("invoke", "toFile", 0, path), configFile);
                }
                catch (Exception e) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, AppengineOperationException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getMessage", 0, e)}, new String[]{"Could not write config file: ", ""})));
                }
                return IndyInterface.bootstrap("invoke", "toString", 0, path);
            }

            @Generated
            public String getRepositoryPath() {
                return IndyInterface.bootstrap("cast", "()", 0, this.repositoryPath.get());
            }

            @Generated
            public String getApplicationDirectoryRoot() {
                return IndyInterface.bootstrap("cast", "()", 0, this.applicationDirectoryRoot.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _writeConfigFiles_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, configFiles, new _writeConfigFiles_closure4(DeployAppengineAtomicOperation.class, DeployAppengineAtomicOperation.class, repositoryPath2, applicationDirectoryRoot2)));
    }

    public static void deleteFiles(List<String> paths) {
        public final class _deleteFiles_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _deleteFiles_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object path) {
                CallSite callSite = IndyInterface.bootstrap("invoke", "delete", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, path));
                try {
                    return callSite;
                }
                catch (Exception e) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, AppengineOperationException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getMessage", 0, e)}, new String[]{"Could not delete config file: ", ""})));
                }
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deleteFiles_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, paths, new _deleteFiles_closure5(DeployAppengineAtomicOperation.class, DeployAppengineAtomicOperation.class));
    }

    public static String getFullDirectoryPath(String localRepositoryDirectory, String repositoryUrl) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "get", 0, Paths.class, localRepositoryDirectory, IndyInterface.bootstrap("invoke", "replace", 0, repositoryUrl, "/", "-"))));
    }

    public static Path generateRandomRepositoryFilePath(String repositoryPath, String applicationDirectoryRoot) {
        CallSite name = IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class));
        String string = applicationDirectoryRoot;
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, Paths.class, repositoryPath, IndyInterface.bootstrap("cast", "()", 0, string) != false ? string : ".", new GStringImpl(new Object[]{name}, new String[]{"", ".yaml"})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DeployAppengineAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public Registry getRegistry() {
        return this.registry;
    }

    @Generated
    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    @Generated
    public AppengineJobExecutor getJobExecutor() {
        return this.jobExecutor;
    }

    @Generated
    public void setJobExecutor(AppengineJobExecutor appengineJobExecutor) {
        this.jobExecutor = appengineJobExecutor;
    }

    @Generated
    public StorageConfigurationProperties getStorageConfiguration() {
        return this.storageConfiguration;
    }

    @Generated
    public void setStorageConfiguration(StorageConfigurationProperties storageConfigurationProperties) {
        this.storageConfiguration = storageConfigurationProperties;
    }

    @Generated
    public GcsStorageService.Factory getStorageServiceFactory() {
        return this.storageServiceFactory;
    }

    @Generated
    public void setStorageServiceFactory(GcsStorageService.Factory factory) {
        this.storageServiceFactory = factory;
    }

    @Generated
    public ArtifactDownloader getArtifactDownloader() {
        return this.artifactDownloader;
    }

    @Generated
    public void setArtifactDownloader(ArtifactDownloader artifactDownloader) {
        this.artifactDownloader = artifactDownloader;
    }

    @Generated
    public DeployAppengineDescription getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(DeployAppengineDescription deployAppengineDescription) {
        this.description = deployAppengineDescription;
    }

    @Generated
    public boolean getUsesGcs() {
        return this.usesGcs;
    }

    @Generated
    public boolean isUsesGcs() {
        return this.usesGcs;
    }

    @Generated
    public void setUsesGcs(boolean bl) {
        this.usesGcs = bl;
    }

    @Generated
    public boolean getContainerDeployment() {
        return this.containerDeployment;
    }

    @Generated
    public boolean isContainerDeployment() {
        return this.containerDeployment;
    }

    @Generated
    public void setContainerDeployment(boolean bl) {
        this.containerDeployment = bl;
    }
}

