/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.appengine.deploy.ops;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.appengine.AppengineJobExecutor;
import com.netflix.spinnaker.clouddriver.appengine.artifacts.GcsStorageService;
import com.netflix.spinnaker.clouddriver.appengine.artifacts.config.StorageConfigurationProperties;
import com.netflix.spinnaker.clouddriver.appengine.config.AppengineConfigurationProperties;
import com.netflix.spinnaker.clouddriver.appengine.deploy.AppengineMutexRepository;
import com.netflix.spinnaker.clouddriver.appengine.deploy.AppengineServerGroupNameResolver;
import com.netflix.spinnaker.clouddriver.appengine.deploy.description.DeployAppengineDescription;
import com.netflix.spinnaker.clouddriver.appengine.deploy.exception.AppengineOperationException;
import com.netflix.spinnaker.clouddriver.appengine.gcsClient.AppengineGcsRepositoryClient;
import com.netflix.spinnaker.clouddriver.artifacts.ArtifactDownloader;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.deploy.DeploymentResult;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.lang.ref.SoftReference;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.beans.factory.annotation.Autowired;

public class DeployAppengineAtomicOperation
implements AtomicOperation<DeploymentResult>,
GroovyObject {
    private static final String BASE_PHASE = "DEPLOY";
    @Autowired
    private Registry registry;
    @Autowired
    private AppengineJobExecutor jobExecutor;
    @Autowired(required=false)
    private StorageConfigurationProperties storageConfiguration;
    @Autowired(required=false)
    private GcsStorageService.Factory storageServiceFactory;
    @Autowired
    private ArtifactDownloader artifactDownloader;
    private DeployAppengineDescription description;
    private boolean usesGcs;
    private boolean containerDeployment;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DeployAppengineAtomicOperation(DeployAppengineDescription description) {
        DeployAppengineDescription deployAppengineDescription;
        MetaClass metaClass;
        CallSite[] callSiteArray = DeployAppengineAtomicOperation.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = deployAppengineDescription = description;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)description))) {
            Object object = callSiteArray[1].callGetProperty(callSiteArray[2].callGroovyObjectGetProperty((Object)description));
            if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"gcs/object")) {
                boolean bl;
                String ref = ShortTypeHandling.castToString((Object)callSiteArray[3].callGetProperty(callSiteArray[4].callGroovyObjectGetProperty((Object)description)));
                if (!DefaultTypeTransformation.booleanUnbox((Object)ref)) {
                    throw (Throwable)callSiteArray[5].callConstructor(AppengineOperationException.class, (Object)"Missing artifact reference for GCS deploy");
                }
                String string = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].call((Object)ref, (Object)"gs://")) ? ref : new GStringImpl(new Object[]{ref}, new String[]{"gs://", ""});
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, DeployAppengineAtomicOperation.class, (GroovyObject)description, (String)"repositoryUrl");
                this.usesGcs = bl = true;
                return;
            } else {
                if (!ScriptBytecodeAdapter.isCase((Object)object, (Object)"docker/image")) throw (Throwable)callSiteArray[12].callConstructor(AppengineOperationException.class, (Object)"Unhandled artifact type in description");
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].callGetProperty(callSiteArray[8].callGroovyObjectGetProperty((Object)description)))) {
                    throw (Throwable)callSiteArray[9].callConstructor(AppengineOperationException.class, (Object)"Missing artifact name for Flex Custom deploy");
                }
                Object object2 = callSiteArray[10].callGetProperty(callSiteArray[11].callGroovyObjectGetProperty((Object)description));
                this.containerDeployment = DefaultTypeTransformation.booleanUnbox((Object)object2);
            }
            return;
        } else {
            boolean bl;
            Object object = callSiteArray[13].callSafe(callSiteArray[14].callGroovyObjectGetProperty((Object)description));
            this.containerDeployment = DefaultTypeTransformation.booleanUnbox((Object)object);
            this.usesGcs = bl = !this.containerDeployment && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[15].call(callSiteArray[16].callGroovyObjectGetProperty((Object)description), (Object)"gs://"));
        }
    }

    private static Task getTask() {
        CallSite[] callSiteArray = DeployAppengineAtomicOperation.$getCallSiteArray();
        return (Task)ScriptBytecodeAdapter.castToType((Object)callSiteArray[17].call(callSiteArray[18].callGetProperty(TaskRepository.class)), Task.class);
    }

    public DeploymentResult operate(List priorOutputs) {
        CallSite[] callSiteArray = DeployAppengineAtomicOperation.$getCallSiteArray();
        Object baseDir = callSiteArray[19].callGetProperty(callSiteArray[20].callGroovyObjectGetProperty((Object)this.description));
        String directoryId = null;
        if (this.containerDeployment) {
            Object object = callSiteArray[21].callGroovyObjectGetProperty((Object)this.description);
            directoryId = ShortTypeHandling.castToString((Object)object);
        } else {
            Object object = callSiteArray[22].callGroovyObjectGetProperty((Object)this.description);
            directoryId = ShortTypeHandling.castToString((Object)object);
        }
        Reference directoryPath = new Reference(callSiteArray[23].callStatic(DeployAppengineAtomicOperation.class, baseDir, (Object)directoryId));
        Reference serviceAccount = new Reference(callSiteArray[24].callGetProperty(callSiteArray[25].callGroovyObjectGetProperty((Object)this.description)));
        Reference region = new Reference(callSiteArray[26].callGetProperty(callSiteArray[27].callGroovyObjectGetProperty((Object)this.description)));
        callSiteArray[28].call(callSiteArray[29].call((Object)this.registry, callSiteArray[30].call((Object)this.registry, ArrayUtil.createArray((Object)"appengine.deployStart", (Object)"account", (Object)serviceAccount.get(), (Object)"region", (Object)region.get()))));
        public final class _operate_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference directoryPath;
            private /* synthetic */ Reference serviceAccount;
            private /* synthetic */ Reference region;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _operate_closure1(Object _outerInstance, Object _thisObject, Reference directoryPath, Reference serviceAccount, Reference region) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.directoryPath = reference3 = directoryPath;
                this.serviceAccount = reference2 = serviceAccount;
                this.region = reference = region;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object doCall(Object it) {
                CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), ScriptBytecodeAdapter.getField(_operate_closure1.class, DeployAppengineAtomicOperation.class, (String)"BASE_PHASE"), (Object)"Initializing creation of version...");
                String newVersionName = null;
                String deployPath = null;
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callGroovyObjectGetProperty((Object)this))) {
                    callSiteArray[3].callCurrent((GroovyObject)this, this.directoryPath.get());
                    Object object = this.directoryPath.get();
                    deployPath = ShortTypeHandling.castToString((Object)object);
                } else {
                    Object startTime = callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].callGroovyObjectGetProperty((Object)this)));
                    String success = "false";
                    try {
                        String string2;
                        Object object = callSiteArray[7].callCurrent((GroovyObject)this, this.directoryPath.get(), (Object)1);
                        deployPath = ShortTypeHandling.castToString((Object)object);
                        success = string2 = "true";
                    }
                    catch (Throwable throwable) {
                        Object duration = callSiteArray[19].call(callSiteArray[20].call(callSiteArray[21].call(callSiteArray[22].callGroovyObjectGetProperty((Object)this))), startTime);
                        callSiteArray[23].call(callSiteArray[24].call(callSiteArray[25].callGroovyObjectGetProperty((Object)this), callSiteArray[26].call(callSiteArray[27].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)"appengine.repositoryDownload", (Object)"account", (Object)this.serviceAccount.get(), (Object)"repositoryType", (Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[28].callGroovyObjectGetProperty((Object)this)) ? "gcs" : "git"), (Object)"success", (Object)success))), duration, callSiteArray[29].callGetProperty(TimeUnit.class));
                        throw throwable;
                    }
                    Object duration = callSiteArray[8].call(callSiteArray[9].call(callSiteArray[10].call(callSiteArray[11].callGroovyObjectGetProperty((Object)this))), startTime);
                    callSiteArray[12].call(callSiteArray[13].call(callSiteArray[14].callGroovyObjectGetProperty((Object)this), callSiteArray[15].call(callSiteArray[16].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)"appengine.repositoryDownload", (Object)"account", (Object)this.serviceAccount.get(), (Object)"repositoryType", (Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].callGroovyObjectGetProperty((Object)this)) ? "gcs" : "git"), (Object)"success", (Object)success))), duration, callSiteArray[18].callGetProperty(TimeUnit.class));
                }
                Object startTime = callSiteArray[30].call(callSiteArray[31].call(callSiteArray[32].callGroovyObjectGetProperty((Object)this)));
                String success = "false";
                try {
                    String string3;
                    Object object = callSiteArray[33].callCurrent((GroovyObject)this, (Object)deployPath);
                    newVersionName = ShortTypeHandling.castToString((Object)object);
                    success = string3 = "true";
                }
                catch (Throwable throwable) {
                    Object duration = callSiteArray[44].call(callSiteArray[45].call(callSiteArray[46].call(callSiteArray[47].callGroovyObjectGetProperty((Object)this))), startTime);
                    callSiteArray[48].call(callSiteArray[49].call(callSiteArray[50].callGroovyObjectGetProperty((Object)this), callSiteArray[51].call(callSiteArray[52].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)"appengine.deploy", (Object)"success", (Object)success, (Object)"account", (Object)this.serviceAccount.get(), (Object)"region", (Object)this.region.get()))), duration, callSiteArray[53].callGetProperty(TimeUnit.class));
                    throw throwable;
                }
                Object duration = callSiteArray[34].call(callSiteArray[35].call(callSiteArray[36].call(callSiteArray[37].callGroovyObjectGetProperty((Object)this))), startTime);
                callSiteArray[38].call(callSiteArray[39].call(callSiteArray[40].callGroovyObjectGetProperty((Object)this), callSiteArray[41].call(callSiteArray[42].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)"appengine.deploy", (Object)"success", (Object)success, (Object)"account", (Object)this.serviceAccount.get(), (Object)"region", (Object)this.region.get()))), duration, callSiteArray[43].callGetProperty(TimeUnit.class));
                Object result = callSiteArray[54].callConstructor(DeploymentResult.class);
                Object object = callSiteArray[55].call(Arrays.class, callSiteArray[56].call((Object)new GStringImpl(new Object[]{this.region.get(), newVersionName}, new String[]{"", ":", ""})));
                ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)result, (String)"serverGroupNames");
                String string4 = newVersionName;
                callSiteArray[57].call(callSiteArray[58].callGetProperty(result), this.region.get(), (Object)string4);
                return result;
            }

            @Generated
            public Object getDirectoryPath() {
                CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                return this.directoryPath.get();
            }

            @Generated
            public Object getServiceAccount() {
                CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                return this.serviceAccount.get();
            }

            @Generated
            public Object getRegion() {
                CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                return this.region.get();
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "updateStatus";
                stringArray[1] = "task";
                stringArray[2] = "containerDeployment";
                stringArray[3] = "createEmptyDirectory";
                stringArray[4] = "monotonicTime";
                stringArray[5] = "clock";
                stringArray[6] = "registry";
                stringArray[7] = "cloneOrUpdateLocalRepository";
                stringArray[8] = "minus";
                stringArray[9] = "monotonicTime";
                stringArray[10] = "clock";
                stringArray[11] = "registry";
                stringArray[12] = "record";
                stringArray[13] = "timer";
                stringArray[14] = "registry";
                stringArray[15] = "createId";
                stringArray[16] = "registry";
                stringArray[17] = "usesGcs";
                stringArray[18] = "NANOSECONDS";
                stringArray[19] = "minus";
                stringArray[20] = "monotonicTime";
                stringArray[21] = "clock";
                stringArray[22] = "registry";
                stringArray[23] = "record";
                stringArray[24] = "timer";
                stringArray[25] = "registry";
                stringArray[26] = "createId";
                stringArray[27] = "registry";
                stringArray[28] = "usesGcs";
                stringArray[29] = "NANOSECONDS";
                stringArray[30] = "monotonicTime";
                stringArray[31] = "clock";
                stringArray[32] = "registry";
                stringArray[33] = "deploy";
                stringArray[34] = "minus";
                stringArray[35] = "monotonicTime";
                stringArray[36] = "clock";
                stringArray[37] = "registry";
                stringArray[38] = "record";
                stringArray[39] = "timer";
                stringArray[40] = "registry";
                stringArray[41] = "createId";
                stringArray[42] = "registry";
                stringArray[43] = "NANOSECONDS";
                stringArray[44] = "minus";
                stringArray[45] = "monotonicTime";
                stringArray[46] = "clock";
                stringArray[47] = "registry";
                stringArray[48] = "record";
                stringArray[49] = "timer";
                stringArray[50] = "registry";
                stringArray[51] = "createId";
                stringArray[52] = "registry";
                stringArray[53] = "NANOSECONDS";
                stringArray[54] = "<$constructor$>";
                stringArray[55] = "asList";
                stringArray[56] = "toString";
                stringArray[57] = "putAt";
                stringArray[58] = "serverGroupNameByRegion";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[59];
                _operate_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_operate_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _operate_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (DeploymentResult)ScriptBytecodeAdapter.castToType((Object)callSiteArray[31].call(AppengineMutexRepository.class, directoryPath.get(), (Object)new _operate_closure1(this, this, directoryPath, serviceAccount, region)), DeploymentResult.class);
    }

    public void createEmptyDirectory(String path) {
        CallSite[] callSiteArray = DeployAppengineAtomicOperation.$getCallSiteArray();
        File directory = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[32].callConstructor(File.class, (Object)path), File.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[33].call((Object)directory))) {
            callSiteArray[34].call((Object)directory);
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[35].call((Object)directory))) {
            throw (Throwable)callSiteArray[36].callConstructor(AppengineOperationException.class, (Object)new GStringImpl(new Object[]{path}, new String[]{"Failed to create directory: ", ""}));
        }
    }

    public String cloneOrUpdateLocalRepository(String directoryPath, Integer retryCount) {
        CallSite[] callSiteArray = DeployAppengineAtomicOperation.$getCallSiteArray();
        Object repositoryUrl = callSiteArray[37].callGroovyObjectGetProperty((Object)this.description);
        Object directory = callSiteArray[38].callConstructor(File.class, (Object)directoryPath);
        Object branch = callSiteArray[39].callGroovyObjectGetProperty((Object)this.description);
        Object branchLogName = branch;
        Object repositoryClient = null;
        if (this.usesGcs) {
            Object object;
            if (ScriptBytecodeAdapter.compareEqual((Object)this.storageConfiguration, null)) {
                throw (Throwable)callSiteArray[40].callConstructor(IllegalStateException.class, (Object)"GCS has been disabled. To enable it, configure storage.gcs.enabled=false and restart clouddriver.");
            }
            Object applicationDirectoryRoot = callSiteArray[41].callGroovyObjectGetProperty((Object)this.description);
            String credentialPath = "";
            String storageAccountName = ShortTypeHandling.castToString((Object)callSiteArray[42].callGroovyObjectGetProperty((Object)this.description));
            if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareNotEqual((Object)storageAccountName, null) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[43].call((Object)storageAccountName))) {
                    Object object2 = callSiteArray[44].callGetProperty(callSiteArray[45].call((Object)this.storageConfiguration, callSiteArray[46].callGroovyObjectGetProperty((Object)this.description)));
                    credentialPath = ShortTypeHandling.castToString((Object)object2);
                } else {
                    String string;
                    storageAccountName = string = "ApplicationDefaultCredentials";
                }
            } else if (ScriptBytecodeAdapter.compareNotEqual((Object)storageAccountName, null) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[47].call((Object)storageAccountName))) {
                Object object3 = callSiteArray[48].callGetProperty(callSiteArray[49].call((Object)this.storageConfiguration, callSiteArray[50].callGroovyObjectGetProperty((Object)this.description)));
                credentialPath = ShortTypeHandling.castToString((Object)object3);
            } else {
                String string;
                storageAccountName = string = "ApplicationDefaultCredentials";
            }
            GcsStorageService storage = (GcsStorageService)ScriptBytecodeAdapter.castToType((Object)callSiteArray[51].call((Object)this.storageServiceFactory, (Object)credentialPath), GcsStorageService.class);
            repositoryClient = object = callSiteArray[52].callConstructor(AppengineGcsRepositoryClient.class, ArrayUtil.createArray((Object)repositoryUrl, (Object)directoryPath, (Object)applicationDirectoryRoot, (Object)storage, (Object)this.jobExecutor));
            String string = "(current)";
            branchLogName = string;
        } else {
            Object object;
            repositoryClient = object = callSiteArray[53].call(callSiteArray[54].callGetProperty(callSiteArray[55].callGroovyObjectGetProperty((Object)this.description)), repositoryUrl, (Object)directoryPath, callSiteArray[56].callGroovyObjectGetProperty((Object)this.description));
        }
        try {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[57].call(directory))) {
                callSiteArray[58].call(callSiteArray[59].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{repositoryUrl}, new String[]{"Grabbing repository ", " into local directory..."}));
                callSiteArray[60].call(directory);
                callSiteArray[61].call(repositoryClient);
            }
            callSiteArray[62].call(callSiteArray[63].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{repositoryUrl, branchLogName}, new String[]{"Fetching updates from ", " for ", "..."}));
            callSiteArray[64].call(repositoryClient, branch);
        }
        catch (Exception e) {
            callSiteArray[65].call(directory);
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)retryCount, (Object)0)) {
                String string = ShortTypeHandling.castToString((Object)callSiteArray[66].callCurrent((GroovyObject)this, (Object)directoryPath, callSiteArray[67].call((Object)retryCount, (Object)1)));
                return string;
            }
            throw (Throwable)e;
        }
        return directoryPath;
    }

    public String deploy(String repositoryPath) {
        Reference repositoryPath2 = new Reference((Object)repositoryPath);
        CallSite[] callSiteArray = DeployAppengineAtomicOperation.$getCallSiteArray();
        Object project = callSiteArray[68].callGetProperty(callSiteArray[69].callGroovyObjectGetProperty((Object)this.description));
        Object accountEmail = callSiteArray[70].callGetProperty(callSiteArray[71].callGroovyObjectGetProperty((Object)this.description));
        Object region = callSiteArray[72].callGetProperty(callSiteArray[73].callGroovyObjectGetProperty((Object)this.description));
        Reference applicationDirectoryRoot = new Reference(callSiteArray[74].callGroovyObjectGetProperty((Object)this.description));
        Object gcloudReleaseTrack = callSiteArray[75].callGetProperty(callSiteArray[76].callGroovyObjectGetProperty((Object)this.description));
        Object serverGroupNameResolver = callSiteArray[77].callConstructor(AppengineServerGroupNameResolver.class, project, region, callSiteArray[78].callGroovyObjectGetProperty((Object)this.description));
        Object versionName = callSiteArray[79].call(serverGroupNameResolver, callSiteArray[80].callGroovyObjectGetProperty((Object)this.description), callSiteArray[81].callGroovyObjectGetProperty((Object)this.description), callSiteArray[82].callGroovyObjectGetProperty((Object)this.description), callSiteArray[83].callGroovyObjectGetProperty((Object)this.description));
        Object imageUrl = callSiteArray[84].callGroovyObjectGetProperty((Object)this.description);
        Object configFiles = callSiteArray[85].callGroovyObjectGetProperty((Object)this.description);
        Object writtenFullConfigFilePaths = callSiteArray[86].callStatic(DeployAppengineAtomicOperation.class, configFiles, (Object)((String)repositoryPath2.get()), applicationDirectoryRoot.get());
        public final class _deploy_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference repositoryPath;
            private /* synthetic */ Reference applicationDirectoryRoot;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _deploy_closure2(Object _outerInstance, Object _thisObject, Reference repositoryPath, Reference applicationDirectoryRoot) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _deploy_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.repositoryPath = reference2 = repositoryPath;
                this.applicationDirectoryRoot = reference = applicationDirectoryRoot;
            }

            public Object doCall(Object it) {
                Object object;
                CallSite[] callSiteArray = _deploy_closure2.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(Paths.class, this.repositoryPath.get(), DefaultTypeTransformation.booleanUnbox((Object)(object = this.applicationDirectoryRoot.get())) ? object : ".", it));
            }

            @Generated
            public String getRepositoryPath() {
                CallSite[] callSiteArray = _deploy_closure2.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.repositoryPath.get());
            }

            @Generated
            public Object getApplicationDirectoryRoot() {
                CallSite[] callSiteArray = _deploy_closure2.$getCallSiteArray();
                return this.applicationDirectoryRoot.get();
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _deploy_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deploy_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "toString";
                stringArray[1] = "get";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _deploy_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_deploy_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _deploy_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object object = callSiteArray[87].callSafe(callSiteArray[88].callGroovyObjectGetProperty((Object)this.description), (Object)new _deploy_closure2(this, this, repositoryPath2, applicationDirectoryRoot));
        List repositoryFullConfigFilePaths = (List)ScriptBytecodeAdapter.asType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createList((Object[])new Object[0])), List.class);
        Object configArtifactPaths = callSiteArray[89].callCurrent((GroovyObject)this, callSiteArray[90].callGroovyObjectGetProperty((Object)this.description), (Object)((String)repositoryPath2.get()), applicationDirectoryRoot.get());
        Object deployCommand = ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[91].callGetProperty(callSiteArray[92].callGroovyObjectGetProperty((Object)this.description))});
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)gcloudReleaseTrack, null) && ScriptBytecodeAdapter.compareNotEqual((Object)gcloudReleaseTrack, (Object)callSiteArray[93].callGetProperty(AppengineConfigurationProperties.ManagedAccount.GcloudReleaseTrack.class))) {
                callSiteArray[94].call(deployCommand, callSiteArray[95].call(callSiteArray[96].call(gcloudReleaseTrack)));
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)gcloudReleaseTrack, null) && ScriptBytecodeAdapter.compareNotEqual((Object)gcloudReleaseTrack, (Object)callSiteArray[97].callGetProperty(AppengineConfigurationProperties.ManagedAccount.GcloudReleaseTrack.class))) {
            callSiteArray[98].call(deployCommand, callSiteArray[99].call(callSiteArray[100].call(gcloudReleaseTrack)));
        }
        deployCommand = callSiteArray[101].call(deployCommand, (Object)ScriptBytecodeAdapter.createList((Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[]{"app", "deploy"}, (Object[])new Object[]{callSiteArray[102].call(callSiteArray[103].call((Object)repositoryFullConfigFilePaths, writtenFullConfigFilePaths), configArtifactPaths)}, (int[])new int[]{2})));
        callSiteArray[104].call(deployCommand, callSiteArray[105].call((Object)"--version=", versionName));
        callSiteArray[106].call(deployCommand, (Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[107].callGroovyObjectGetProperty((Object)this.description)) ? "--promote" : "--no-promote"));
        callSiteArray[108].call(deployCommand, (Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[109].callGroovyObjectGetProperty((Object)this.description)) ? "--stop-previous-version" : "--no-stop-previous-version"));
        callSiteArray[110].call(deployCommand, callSiteArray[111].call((Object)"--project=", project));
        callSiteArray[112].call(deployCommand, callSiteArray[113].call((Object)"--account=", accountEmail));
        if (this.containerDeployment) {
            callSiteArray[114].call(deployCommand, callSiteArray[115].call((Object)"--image-url=", imageUrl));
        }
        callSiteArray[116].call(callSiteArray[117].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{versionName}, new String[]{"Deploying version ", "..."}));
        Object startTime = callSiteArray[118].call(callSiteArray[119].call((Object)this.registry));
        String success = "false";
        try {
            try {
                String string;
                callSiteArray[120].call((Object)this.jobExecutor, deployCommand);
                success = string = "true";
            }
            catch (Exception e) {
                throw (Throwable)callSiteArray[121].callConstructor(AppengineOperationException.class, (Object)new GStringImpl(new Object[]{callSiteArray[122].call(deployCommand, (Object)" "), callSiteArray[123].call((Object)e)}, new String[]{"Failed to deploy to App Engine with command ", ": ", ""}));
            }
        }
        catch (Throwable throwable) {
            Object duration = callSiteArray[136].call(callSiteArray[137].call(callSiteArray[138].call((Object)this.registry)), startTime);
            Object id = callSiteArray[139].call((Object)this.registry, ArrayUtil.createArray((Object)"appengine.deploy", (Object)"account", (Object)callSiteArray[140].callGetProperty(callSiteArray[141].callGroovyObjectGetProperty((Object)this.description)), (Object)"region", (Object)callSiteArray[142].callGetProperty(callSiteArray[143].callGroovyObjectGetProperty((Object)this.description)), (Object)"success", (Object)success));
            callSiteArray[144].call(callSiteArray[145].call((Object)this.registry, id), duration, callSiteArray[146].callGetProperty(TimeUnit.class));
            callSiteArray[147].callStatic(DeployAppengineAtomicOperation.class, writtenFullConfigFilePaths);
            throw throwable;
        }
        Object duration = callSiteArray[124].call(callSiteArray[125].call(callSiteArray[126].call((Object)this.registry)), startTime);
        Object id = callSiteArray[127].call((Object)this.registry, ArrayUtil.createArray((Object)"appengine.deploy", (Object)"account", (Object)callSiteArray[128].callGetProperty(callSiteArray[129].callGroovyObjectGetProperty((Object)this.description)), (Object)"region", (Object)callSiteArray[130].callGetProperty(callSiteArray[131].callGroovyObjectGetProperty((Object)this.description)), (Object)"success", (Object)success));
        callSiteArray[132].call(callSiteArray[133].call((Object)this.registry, id), duration, callSiteArray[134].callGetProperty(TimeUnit.class));
        callSiteArray[135].callStatic(DeployAppengineAtomicOperation.class, writtenFullConfigFilePaths);
        callSiteArray[148].call(callSiteArray[149].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{versionName}, new String[]{"Done deploying version ", "..."}));
        return ShortTypeHandling.castToString((Object)versionName);
    }

    /*
     * WARNING - void declaration
     */
    public List<String> fetchConfigArtifacts(List<Artifact> configArtifacts, String repositoryPath, String applicationDirectoryRoot) {
        void var3_3;
        Reference repositoryPath2 = new Reference((Object)repositoryPath);
        Reference applicationDirectoryRoot2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = DeployAppengineAtomicOperation.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox(configArtifacts)) {
            return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        }
        public final class _fetchConfigArtifacts_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference repositoryPath;
            private /* synthetic */ Reference applicationDirectoryRoot;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _fetchConfigArtifacts_closure3(Object _outerInstance, Object _thisObject, Reference repositoryPath, Reference applicationDirectoryRoot) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _fetchConfigArtifacts_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.repositoryPath = reference2 = repositoryPath;
                this.applicationDirectoryRoot = reference = applicationDirectoryRoot;
            }

            public Object doCall(Object artifact) {
                CallSite[] callSiteArray = _fetchConfigArtifacts_closure3.$getCallSiteArray();
                Object path = callSiteArray[0].callCurrent((GroovyObject)this, this.repositoryPath.get(), this.applicationDirectoryRoot.get());
                try {
                    callSiteArray[1].call(callSiteArray[2].call(path), callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this), artifact));
                }
                catch (Exception e) {
                    throw (Throwable)callSiteArray[5].callConstructor(AppengineOperationException.class, (Object)new GStringImpl(new Object[]{callSiteArray[6].call((Object)e)}, new String[]{"Could not download artifact as config file: ", ""}));
                }
                return callSiteArray[7].call(path);
            }

            @Generated
            public String getRepositoryPath() {
                CallSite[] callSiteArray = _fetchConfigArtifacts_closure3.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.repositoryPath.get());
            }

            @Generated
            public String getApplicationDirectoryRoot() {
                CallSite[] callSiteArray = _fetchConfigArtifacts_closure3.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.applicationDirectoryRoot.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fetchConfigArtifacts_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "generateRandomRepositoryFilePath";
                stringArray[1] = "leftShift";
                stringArray[2] = "toFile";
                stringArray[3] = "download";
                stringArray[4] = "artifactDownloader";
                stringArray[5] = "<$constructor$>";
                stringArray[6] = "getMessage";
                stringArray[7] = "toString";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _fetchConfigArtifacts_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_fetchConfigArtifacts_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _fetchConfigArtifacts_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[150].call(configArtifacts, (Object)new _fetchConfigArtifacts_closure3(this, this, repositoryPath2, applicationDirectoryRoot2)), List.class);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> writeConfigFiles(List<String> configFiles, String repositoryPath, String applicationDirectoryRoot) {
        void var2_2;
        Reference repositoryPath2 = new Reference((Object)repositoryPath);
        Reference applicationDirectoryRoot2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = DeployAppengineAtomicOperation.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox(configFiles)) {
            return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        }
        public final class _writeConfigFiles_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference repositoryPath;
            private /* synthetic */ Reference applicationDirectoryRoot;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _writeConfigFiles_closure4(Object _outerInstance, Object _thisObject, Reference repositoryPath, Reference applicationDirectoryRoot) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _writeConfigFiles_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.repositoryPath = reference2 = repositoryPath;
                this.applicationDirectoryRoot = reference = applicationDirectoryRoot;
            }

            public Object doCall(Object configFile) {
                CallSite[] callSiteArray = _writeConfigFiles_closure4.$getCallSiteArray();
                Object path = callSiteArray[0].callCurrent((GroovyObject)this, this.repositoryPath.get(), this.applicationDirectoryRoot.get());
                try {
                    callSiteArray[1].call(callSiteArray[2].call(path), configFile);
                }
                catch (Exception e) {
                    throw (Throwable)callSiteArray[3].callConstructor(AppengineOperationException.class, (Object)new GStringImpl(new Object[]{callSiteArray[4].call((Object)e)}, new String[]{"Could not write config file: ", ""}));
                }
                return callSiteArray[5].call(path);
            }

            @Generated
            public String getRepositoryPath() {
                CallSite[] callSiteArray = _writeConfigFiles_closure4.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.repositoryPath.get());
            }

            @Generated
            public String getApplicationDirectoryRoot() {
                CallSite[] callSiteArray = _writeConfigFiles_closure4.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.applicationDirectoryRoot.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _writeConfigFiles_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "generateRandomRepositoryFilePath";
                stringArray[1] = "leftShift";
                stringArray[2] = "toFile";
                stringArray[3] = "<$constructor$>";
                stringArray[4] = "getMessage";
                stringArray[5] = "toString";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _writeConfigFiles_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_writeConfigFiles_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _writeConfigFiles_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[151].call(configFiles, (Object)new _writeConfigFiles_closure4(DeployAppengineAtomicOperation.class, DeployAppengineAtomicOperation.class, repositoryPath2, applicationDirectoryRoot2)), List.class);
    }

    public static void deleteFiles(List<String> paths) {
        CallSite[] callSiteArray = DeployAppengineAtomicOperation.$getCallSiteArray();
        public final class _deleteFiles_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _deleteFiles_closure5(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _deleteFiles_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object path) {
                CallSite[] callSiteArray = _deleteFiles_closure5.$getCallSiteArray();
                Object object = callSiteArray[0].call(callSiteArray[1].callConstructor(File.class, path));
                try {
                    return object;
                }
                catch (Exception e) {
                    throw (Throwable)callSiteArray[2].callConstructor(AppengineOperationException.class, (Object)new GStringImpl(new Object[]{callSiteArray[3].call((Object)e)}, new String[]{"Could not delete config file: ", ""}));
                }
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deleteFiles_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "delete";
                stringArray[1] = "<$constructor$>";
                stringArray[2] = "<$constructor$>";
                stringArray[3] = "getMessage";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _deleteFiles_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_deleteFiles_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _deleteFiles_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[152].call(paths, (Object)new _deleteFiles_closure5(DeployAppengineAtomicOperation.class, DeployAppengineAtomicOperation.class));
    }

    public static String getFullDirectoryPath(String localRepositoryDirectory, String repositoryUrl) {
        CallSite[] callSiteArray = DeployAppengineAtomicOperation.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[153].call(callSiteArray[154].call(Paths.class, (Object)localRepositoryDirectory, callSiteArray[155].call((Object)repositoryUrl, (Object)"/", (Object)"-"))));
    }

    public static Path generateRandomRepositoryFilePath(String repositoryPath, String applicationDirectoryRoot) {
        CallSite[] callSiteArray = DeployAppengineAtomicOperation.$getCallSiteArray();
        Object name = callSiteArray[156].call(callSiteArray[157].call(UUID.class));
        String string = applicationDirectoryRoot;
        return (Path)ScriptBytecodeAdapter.castToType((Object)callSiteArray[158].call(Paths.class, (Object)repositoryPath, (Object)(DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "."), (Object)new GStringImpl(new Object[]{name}, new String[]{"", ".yaml"})), Path.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DeployAppengineAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public Registry getRegistry() {
        return this.registry;
    }

    @Generated
    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    @Generated
    public AppengineJobExecutor getJobExecutor() {
        return this.jobExecutor;
    }

    @Generated
    public void setJobExecutor(AppengineJobExecutor appengineJobExecutor) {
        this.jobExecutor = appengineJobExecutor;
    }

    @Generated
    public StorageConfigurationProperties getStorageConfiguration() {
        return this.storageConfiguration;
    }

    @Generated
    public void setStorageConfiguration(StorageConfigurationProperties storageConfigurationProperties) {
        this.storageConfiguration = storageConfigurationProperties;
    }

    @Generated
    public GcsStorageService.Factory getStorageServiceFactory() {
        return this.storageServiceFactory;
    }

    @Generated
    public void setStorageServiceFactory(GcsStorageService.Factory factory) {
        this.storageServiceFactory = factory;
    }

    @Generated
    public ArtifactDownloader getArtifactDownloader() {
        return this.artifactDownloader;
    }

    @Generated
    public void setArtifactDownloader(ArtifactDownloader artifactDownloader) {
        this.artifactDownloader = artifactDownloader;
    }

    @Generated
    public DeployAppengineDescription getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(DeployAppengineDescription deployAppengineDescription) {
        this.description = deployAppengineDescription;
    }

    @Generated
    public boolean getUsesGcs() {
        return this.usesGcs;
    }

    @Generated
    public boolean isUsesGcs() {
        return this.usesGcs;
    }

    @Generated
    public void setUsesGcs(boolean bl) {
        this.usesGcs = bl;
    }

    @Generated
    public boolean getContainerDeployment() {
        return this.containerDeployment;
    }

    @Generated
    public boolean isContainerDeployment() {
        return this.containerDeployment;
    }

    @Generated
    public void setContainerDeployment(boolean bl) {
        this.containerDeployment = bl;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "artifact";
        stringArray[1] = "type";
        stringArray[2] = "artifact";
        stringArray[3] = "reference";
        stringArray[4] = "artifact";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "startsWith";
        stringArray[7] = "name";
        stringArray[8] = "artifact";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "name";
        stringArray[11] = "artifact";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "trim";
        stringArray[14] = "containerImageUrl";
        stringArray[15] = "startsWith";
        stringArray[16] = "repositoryUrl";
        stringArray[17] = "get";
        stringArray[18] = "threadLocalTask";
        stringArray[19] = "localRepositoryDirectory";
        stringArray[20] = "credentials";
        stringArray[21] = "containerImageUrl";
        stringArray[22] = "repositoryUrl";
        stringArray[23] = "getFullDirectoryPath";
        stringArray[24] = "serviceAccountEmail";
        stringArray[25] = "credentials";
        stringArray[26] = "region";
        stringArray[27] = "credentials";
        stringArray[28] = "increment";
        stringArray[29] = "counter";
        stringArray[30] = "createId";
        stringArray[31] = "atomicWrapper";
        stringArray[32] = "<$constructor$>";
        stringArray[33] = "exists";
        stringArray[34] = "deleteDir";
        stringArray[35] = "mkdirs";
        stringArray[36] = "<$constructor$>";
        stringArray[37] = "repositoryUrl";
        stringArray[38] = "<$constructor$>";
        stringArray[39] = "branch";
        stringArray[40] = "<$constructor$>";
        stringArray[41] = "applicationDirectoryRoot";
        stringArray[42] = "storageAccountName";
        stringArray[43] = "isEmpty";
        stringArray[44] = "jsonPath";
        stringArray[45] = "getAccount";
        stringArray[46] = "storageAccountName";
        stringArray[47] = "isEmpty";
        stringArray[48] = "jsonPath";
        stringArray[49] = "getAccount";
        stringArray[50] = "storageAccountName";
        stringArray[51] = "newForCredentials";
        stringArray[52] = "<$constructor$>";
        stringArray[53] = "buildRepositoryClient";
        stringArray[54] = "gitCredentials";
        stringArray[55] = "credentials";
        stringArray[56] = "gitCredentialType";
        stringArray[57] = "exists";
        stringArray[58] = "updateStatus";
        stringArray[59] = "task";
        stringArray[60] = "mkdir";
        stringArray[61] = "initializeLocalDirectory";
        stringArray[62] = "updateStatus";
        stringArray[63] = "task";
        stringArray[64] = "updateLocalDirectoryWithVersion";
        stringArray[65] = "deleteDir";
        stringArray[66] = "cloneOrUpdateLocalRepository";
        stringArray[67] = "minus";
        stringArray[68] = "project";
        stringArray[69] = "credentials";
        stringArray[70] = "serviceAccountEmail";
        stringArray[71] = "credentials";
        stringArray[72] = "region";
        stringArray[73] = "credentials";
        stringArray[74] = "applicationDirectoryRoot";
        stringArray[75] = "gcloudReleaseTrack";
        stringArray[76] = "credentials";
        stringArray[77] = "<$constructor$>";
        stringArray[78] = "credentials";
        stringArray[79] = "resolveNextServerGroupName";
        stringArray[80] = "application";
        stringArray[81] = "stack";
        stringArray[82] = "freeFormDetails";
        stringArray[83] = "suppressVersionString";
        stringArray[84] = "containerImageUrl";
        stringArray[85] = "configFiles";
        stringArray[86] = "writeConfigFiles";
        stringArray[87] = "collect";
        stringArray[88] = "configFilepaths";
        stringArray[89] = "fetchConfigArtifacts";
        stringArray[90] = "configArtifacts";
        stringArray[91] = "gcloudPath";
        stringArray[92] = "credentials";
        stringArray[93] = "STABLE";
        stringArray[94] = "leftShift";
        stringArray[95] = "toLowerCase";
        stringArray[96] = "toString";
        stringArray[97] = "STABLE";
        stringArray[98] = "leftShift";
        stringArray[99] = "toLowerCase";
        stringArray[100] = "toString";
        stringArray[101] = "plus";
        stringArray[102] = "plus";
        stringArray[103] = "plus";
        stringArray[104] = "leftShift";
        stringArray[105] = "plus";
        stringArray[106] = "leftShift";
        stringArray[107] = "promote";
        stringArray[108] = "leftShift";
        stringArray[109] = "stopPreviousVersion";
        stringArray[110] = "leftShift";
        stringArray[111] = "plus";
        stringArray[112] = "leftShift";
        stringArray[113] = "plus";
        stringArray[114] = "leftShift";
        stringArray[115] = "plus";
        stringArray[116] = "updateStatus";
        stringArray[117] = "task";
        stringArray[118] = "monotonicTime";
        stringArray[119] = "clock";
        stringArray[120] = "runCommand";
        stringArray[121] = "<$constructor$>";
        stringArray[122] = "join";
        stringArray[123] = "getMessage";
        stringArray[124] = "minus";
        stringArray[125] = "monotonicTime";
        stringArray[126] = "clock";
        stringArray[127] = "createId";
        stringArray[128] = "serviceAccountEmail";
        stringArray[129] = "credentials";
        stringArray[130] = "region";
        stringArray[131] = "credentials";
        stringArray[132] = "record";
        stringArray[133] = "timer";
        stringArray[134] = "NANOSECONDS";
        stringArray[135] = "deleteFiles";
        stringArray[136] = "minus";
        stringArray[137] = "monotonicTime";
        stringArray[138] = "clock";
        stringArray[139] = "createId";
        stringArray[140] = "serviceAccountEmail";
        stringArray[141] = "credentials";
        stringArray[142] = "region";
        stringArray[143] = "credentials";
        stringArray[144] = "record";
        stringArray[145] = "timer";
        stringArray[146] = "NANOSECONDS";
        stringArray[147] = "deleteFiles";
        stringArray[148] = "updateStatus";
        stringArray[149] = "task";
        stringArray[150] = "collect";
        stringArray[151] = "collect";
        stringArray[152] = "each";
        stringArray[153] = "toString";
        stringArray[154] = "get";
        stringArray[155] = "replace";
        stringArray[156] = "toString";
        stringArray[157] = "randomUUID";
        stringArray[158] = "get";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[159];
        DeployAppengineAtomicOperation.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DeployAppengineAtomicOperation.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DeployAppengineAtomicOperation.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

