/*
 * Copyright 2019 Pivotal, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.netflix.spinnaker.clouddriver.cloudfoundry.client.api;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.CreateTask;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Task;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;

public interface TaskService {

  @POST("/v3/apps/{guid}/tasks")
  Call<Task> createTask(@Path("guid") String guid, @Body CreateTask body);

  @GET("/v3/tasks/{guid}")
  Call<Task> getTask(@Path("guid") String guid);

  @POST("/v3/tasks/{guid}/actions/cancel")
  Call<Task> cancelTask(@Path("guid") String guid, @Body Object emptyBody);
}
